/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.util.Pair;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDCodeBlockSpan;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;

class CodeBlockSyntax
extends EditSyntaxAdapter {
    private int mColor;

    public CodeBlockSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getTheme().getBackgroundColor();
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        List<Pair<Integer, Integer>> list = Utils.find(editable.toString(), "```");
        for (int i = list.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> pair = list.get(i);
            int start = (Integer)pair.first;
            int end = (Integer)pair.second;
            List<Integer> middleList = Utils.getNewLineCharPosition((SpannableStringBuilder)editable, start, end);
            int current = start;
            MDCodeBlockSpan parentSpan = null;
            for (int j = 0; j < middleList.size(); ++j) {
                int position = middleList.get(j);
                MDCodeBlockSpan mdCodeBlockSpan = new MDCodeBlockSpan(this.mColor);
                if (position == current) {
                    editTokenList.add(new EditToken(mdCodeBlockSpan, position - 1, position + 1, j == 0 ? 34 : 18));
                } else {
                    editTokenList.add(new EditToken(mdCodeBlockSpan, current, position, j == 0 ? 34 : 18));
                }
                if (parentSpan != null) {
                    parentSpan.setNext(mdCodeBlockSpan);
                }
                parentSpan = mdCodeBlockSpan;
                current = position + 1;
            }
            MDCodeBlockSpan mdCodeBlockSpan = new MDCodeBlockSpan(this.mColor);
            editTokenList.add(new EditToken(mdCodeBlockSpan, end, end + "```".length() + (end + "```".length() >= editable.length() ? 0 : 1), 17));
            if (parentSpan == null) continue;
            parentSpan.setNext(mdCodeBlockSpan);
        }
        return editTokenList;
    }
}

