/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.style.StyleSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.ArrayList;
import java.util.List;

class BoldSyntax
extends EditSyntaxAdapter
implements SyntaxUtils.OnWhatSpanCallback {
    private static final String PATTERN_ASTERISK = "(\\*\\*)(.*?)(\\*\\*)";
    private static final String PATTERN_UNDERLINE = "(__)(.*?)(__)";

    public BoldSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        editTokenList.addAll(SyntaxUtils.parse(editable, PATTERN_ASTERISK, (SyntaxUtils.OnWhatSpanCallback)this));
        editTokenList.addAll(SyntaxUtils.parse(editable, PATTERN_UNDERLINE, (SyntaxUtils.OnWhatSpanCallback)this));
        return editTokenList;
    }

    @Override
    public Object whatSpan() {
        return new StyleSpan(1);
    }
}

