/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDQuoteSpan;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class BlockQuotesSyntax
extends EditSyntaxAdapter {
    private static final String PATTERN = "^(> )(.*?)$";
    private int mColor;

    public BlockQuotesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getBlockQuotesLineColor();
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        StringBuilder content = new StringBuilder((CharSequence)editable);
        Matcher m = Pattern.compile(PATTERN, 8).matcher(content);
        ArrayList<String> matchList = new ArrayList<String>();
        while (m.find()) {
            matchList.add(m.group());
        }
        for (String match : matchList) {
            int nested = BlockQuotesSyntax.calculateNested(match);
            if (nested == 0) {
                return editTokenList;
            }
            int index = content.indexOf(match);
            int length = match.length();
            editTokenList.add(new EditToken((Object)new MDQuoteSpan(this.mColor, nested), index, index + length));
            content.replace(index, index + length, Utils.getPlaceHolder(match));
        }
        return editTokenList;
    }

    private static int calculateNested(@NonNull String text) {
        String sub;
        int nested = 0;
        while ((nested + 1) * "> ".length() <= text.length() && "> ".equals(sub = text.substring(nested * "> ".length(), (nested + 1) * "> ".length()))) {
            ++nested;
        }
        return nested;
    }
}

