/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.style.QuoteSpan;

public class MDTodoSpan
extends QuoteSpan {
    private static final int GAP_WIDTH_PLUS = 10;
    private int mMarginLength = 50;
    protected final int mColor;

    public MDTodoSpan(int color) {
        super(color);
        this.mColor = color;
    }

    public int getLeadingMargin(boolean first) {
        return super.getLeadingMargin(first) + 10 + this.mMarginLength;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first) {
            return;
        }
        Paint.Style style = p.getStyle();
        float strokeWidth = p.getStrokeWidth();
        int color = p.getColor();
        float height = bottom - top;
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth(height * 1.0f / 10.0f > 2.0f ? height * 1.0f / 9.0f : 2.0f);
        p.setColor(this.mColor);
        p.setStrokeJoin(Paint.Join.ROUND);
        p.setStrokeCap(Paint.Cap.ROUND);
        RectF rectF = new RectF((float)x + height * 1.0f / 9.0f, (float)top + height * 1.0f / 9.0f, (float)x + height * 8.0f / 9.0f, (float)bottom - height * 1.0f / 9.0f);
        c.drawRoundRect(rectF, height * 2.0f / 9.0f, height * 2.0f / 9.0f, p);
        p.setStyle(style);
        p.setColor(color);
        p.setStrokeWidth(strokeWidth);
        this.mMarginLength = (int)height;
    }
}

