/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.span;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.text.style.DynamicDrawableSpan;
import android.view.View;
import com.yydcdut.markdown.drawable.ForwardingDrawable;
import com.yydcdut.markdown.loader.MDImageLoader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MDImageSpan
extends DynamicDrawableSpan
implements Handler.Callback {
    private static Pattern sImageUrlPattern = Pattern.compile("^(.*?)/(\\d+)\\$(\\d+)$");
    private String mImageUri;
    private Drawable mPlaceHolder;
    private Drawable mFinalDrawable;
    private final ForwardingDrawable mActualDrawable;
    private boolean isAttached;
    private boolean isDetached;
    private View mAttachedView;
    private boolean mIsRequestSubmitted = false;
    private MDImageLoader mMDImageLoader;
    private Handler mHandler;
    private static final int MSG_SUCCESS = 0;
    private static final int MSG_ERROR = 1;
    private Runnable mLoadRunnable = new Runnable(){

        @Override
        public void run() {
            byte[] bytes = null;
            try {
                bytes = MDImageSpan.this.mMDImageLoader.loadSync(MDImageSpan.getUrl(MDImageSpan.this.mImageUri));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bytes == null) {
                MDImageSpan.this.mHandler.sendEmptyMessage(1);
            } else {
                Drawable drawable = MDImageSpan.this.getDrawable(bytes);
                Message message = Message.obtain();
                message.what = 0;
                message.obj = drawable;
                MDImageSpan.this.mHandler.sendMessage(message);
            }
        }
    };

    private static Drawable createEmptyDrawable(int width, int height) {
        ColorDrawable d = new ColorDrawable(0);
        d.setBounds(0, 0, width, height);
        return d;
    }

    public MDImageSpan(String uri, int width, int height, MDImageLoader MDImageLoader2) {
        this(uri, MDImageSpan.createEmptyDrawable(MDImageSpan.getSize(uri, width, height)[0], MDImageSpan.getSize(uri, width, height)[1]), MDImageLoader2);
    }

    private MDImageSpan(String uri, Drawable placeHolder, MDImageLoader MDImageLoader2) {
        super(0);
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        MDImageSpan.getUrl(uri);
        this.mMDImageLoader = MDImageLoader2;
        this.mImageUri = uri;
        this.mPlaceHolder = placeHolder;
        this.mActualDrawable = new ForwardingDrawable(this.mPlaceHolder);
        Rect bounds = this.mPlaceHolder.getBounds();
        if (bounds.right == 0 || bounds.bottom == 0) {
            this.mActualDrawable.setBounds(0, 0, this.mPlaceHolder.getIntrinsicWidth(), this.mPlaceHolder.getIntrinsicHeight());
        } else {
            this.mActualDrawable.setBounds(bounds);
        }
    }

    public Drawable getDrawable() {
        return this.mActualDrawable;
    }

    public void onAttach(@NonNull View view) {
        this.isAttached = true;
        if (this.mAttachedView != view) {
            this.mActualDrawable.setCallback(null);
            if (this.mAttachedView != null) {
                throw new IllegalStateException("has been attached to view:" + this.mAttachedView);
            }
            this.mAttachedView = view;
            this.mActualDrawable.setCallback((Drawable.Callback)this.mAttachedView);
        }
        if (!this.mIsRequestSubmitted) {
            this.submitRequest();
        }
    }

    private void submitRequest() {
        this.mIsRequestSubmitted = true;
        new Thread(this.mLoadRunnable).start();
    }

    private void setImageWithIntrinsicBounds(@NonNull Drawable drawable) {
        if (this.mFinalDrawable != drawable && drawable != null) {
            this.mActualDrawable.setCurrent(drawable);
            this.mFinalDrawable = drawable;
        }
    }

    private BitmapDrawable createBitmapDrawable(Bitmap bitmap) {
        BitmapDrawable drawable;
        if (this.mAttachedView != null) {
            Context context = this.mAttachedView.getContext();
            drawable = new BitmapDrawable(context.getResources(), bitmap);
        } else {
            drawable = new BitmapDrawable(null, bitmap);
        }
        return drawable;
    }

    private static int calculateSampleSize(@NonNull BitmapFactory.Options options, int expectWidth, int expectHeight) {
        int sampleSize = 1;
        while (options.outHeight / sampleSize > expectWidth || options.outWidth / sampleSize > expectHeight) {
            sampleSize <<= 1;
        }
        return sampleSize;
    }

    private Drawable getDrawable(@NonNull byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        BitmapFactory.Options calculateOptions = new BitmapFactory.Options();
        calculateOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)calculateOptions);
        int expectWidth = this.mActualDrawable.getIntrinsicWidth();
        int expectHeight = this.mActualDrawable.getIntrinsicHeight();
        int sampleSize = 1;
        if (expectWidth >= 0 && expectHeight >= 0) {
            sampleSize = MDImageSpan.calculateSampleSize(calculateOptions, expectWidth, expectHeight);
        } else if (this.mPlaceHolder.getBounds().width() >= 0 && this.mPlaceHolder.getBounds().height() >= 0) {
            Rect rect = this.mPlaceHolder.getBounds();
            sampleSize = MDImageSpan.calculateSampleSize(calculateOptions, rect.width(), rect.height());
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        return this.createBitmapDrawable(bitmap);
    }

    public void onDetach() {
        this.isDetached = true;
        if (!this.isAttached) {
            return;
        }
        this.mActualDrawable.setCallback(null);
        this.mAttachedView = null;
        this.mActualDrawable.setCurrent(this.mPlaceHolder);
        this.mHandler.removeCallbacksAndMessages(null);
    }

    @NonNull
    private static int[] getSize(String sourceUrl, int defaultWidth, int defaultHeight) {
        Matcher m = sImageUrlPattern.matcher(sourceUrl);
        int[] size = new int[]{defaultWidth, defaultHeight};
        if (m.find()) {
            if (TextUtils.isDigitsOnly((CharSequence)m.group(2))) {
                size[0] = Integer.valueOf(m.group(2));
            }
            if (TextUtils.isDigitsOnly((CharSequence)m.group(3))) {
                size[1] = Integer.valueOf(m.group(3));
            }
        }
        return size;
    }

    @NonNull
    private static String getUrl(String sourceUrl) {
        Matcher m = sImageUrlPattern.matcher(sourceUrl);
        if (m.find()) {
            return m.group(1);
        }
        return sourceUrl;
    }

    public boolean handleMessage(Message msg) {
        if (!this.isDetached && msg.what == 0 && msg.obj instanceof Drawable) {
            Drawable drawable = (Drawable)msg.obj;
            this.setImageWithIntrinsicBounds(drawable);
        }
        return false;
    }
}

