/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.text.style.LineBackgroundSpan;

public class MDCodeBlockSpan
implements LineBackgroundSpan {
    private final int mColor;
    private Drawable mDrawable;
    private String mText;
    private String mLanguage;
    private MDCodeBlockSpan mNext;

    public MDCodeBlockSpan(int color) {
        this.mColor = color;
    }

    public MDCodeBlockSpan(int color, String language, boolean isBeginning, boolean isEnding, String text) {
        this.mColor = color;
        this.mLanguage = language;
        if (isBeginning || isEnding) {
            GradientDrawable d = new GradientDrawable();
            d.setColor(this.mColor);
            if (isBeginning && !isEnding) {
                d.setCornerRadii(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f});
            } else if (!isBeginning && isEnding) {
                d.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            } else {
                d.setCornerRadius(10.0f);
            }
            this.mDrawable = d;
            this.mText = text;
        }
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setNext(MDCodeBlockSpan next) {
        this.mNext = next;
    }

    public MDCodeBlockSpan getNext() {
        return this.mNext;
    }

    public void drawBackground(Canvas c, Paint p, int left, int right, int top, int baseline, int bottom, CharSequence text, int start, int end, int lnum) {
        if (this.mDrawable != null && !TextUtils.isEmpty((CharSequence)this.mText) && (this.mText.startsWith(text.subSequence(start, end).toString()) || text.subSequence(start, end).toString().startsWith(this.mText))) {
            this.mDrawable.setBounds(left, top, right, bottom);
            this.mDrawable.draw(c);
        } else {
            Paint.Style style = p.getStyle();
            int color = p.getColor();
            p.setStyle(Paint.Style.FILL);
            p.setColor(this.mColor);
            c.drawRect((float)left, (float)top, (float)right, (float)bottom, p);
            p.setStyle(style);
            p.setColor(color);
        }
    }
}

