/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.prettify;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.utils.Utils;
import java.util.List;
import java.util.Map;
import prettify.PrettifyParser;
import syntaxhighlight.ParseResult;
import syntaxhighlight.Parser;

public class PrettifyHighLighter {
    private Map<String, Integer> mColorMap;
    private Parser mParser;

    public PrettifyHighLighter(@NonNull MarkdownConfiguration markdownConfiguration) {
        this.mColorMap = Utils.buildColorsMap(markdownConfiguration.getTheme());
        this.mParser = new PrettifyParser();
    }

    public SpannableStringBuilder highLight(String language, SpannableStringBuilder sourceCode, int start, int end) {
        List<ParseResult> results = this.mParser.parse(language, sourceCode.toString().substring(start, end));
        for (ParseResult result : results) {
            String type = result.getStyleKeys().get(0);
            sourceCode.setSpan((Object)new ForegroundColorSpan(this.getColor(type)), start + result.getOffset(), start + result.getOffset() + result.getLength(), 33);
        }
        return sourceCode;
    }

    private int getColor(String type) {
        return this.mColorMap.containsKey(type) ? this.mColorMap.get(type) : this.mColorMap.get("pln");
    }
}

