/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.loader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.util.Locale;

public interface MDImageLoader {
    @Nullable
    public byte[] loadSync(@NonNull String var1) throws IOException;

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https"),
        FILE("file"),
        ASSETS("assets"),
        DRAWABLE("drawable"),
        UNKNOWN("");

        private String scheme;
        private String uriPrefix;

        private Scheme(String scheme) {
            this.scheme = scheme;
            this.uriPrefix = scheme + "://";
        }

        public static Scheme ofUri(String uri) {
            if (uri != null) {
                for (Scheme s : Scheme.values()) {
                    if (!s.belongsTo(uri)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        private boolean belongsTo(String uri) {
            return uri.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        public String crop(String uri) {
            if (!this.belongsTo(uri)) {
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", uri, this.scheme));
            }
            return uri.substring(this.uriPrefix.length());
        }
    }
}

