/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.loader;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yydcdut.markdown.loader.MDImageLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class DefaultLoader
implements MDImageLoader {
    private Context mContext;

    public DefaultLoader(Context context) {
        this.mContext = context;
    }

    @Override
    @Nullable
    public byte[] loadSync(@NonNull String url) throws IOException {
        byte[] bytes = null;
        switch (MDImageLoader.Scheme.ofUri(url)) {
            case HTTP: 
            case HTTPS: {
                return DefaultLoader.http(url);
            }
            case FILE: {
                return DefaultLoader.sdCard(url);
            }
            case ASSETS: {
                return this.assets(url);
            }
            case DRAWABLE: {
                return this.drawable(url);
            }
        }
        return bytes;
    }

    @Nullable
    private static byte[] http(@NonNull String http) throws IOException {
        URL url = new URL(http);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(5000);
        BufferedInputStream in = new BufferedInputStream(httpURLConnection.getInputStream());
        byte[] bytes = DefaultLoader.getBytes(in);
        httpURLConnection.disconnect();
        return bytes;
    }

    @Nullable
    private static byte[] sdCard(@NonNull String url) throws IOException {
        String path = MDImageLoader.Scheme.FILE.crop(url);
        FileInputStream inputStream = new FileInputStream(path);
        byte[] bytes = DefaultLoader.getBytes(inputStream);
        DefaultLoader.closeStream(inputStream);
        return bytes;
    }

    @Nullable
    private byte[] assets(@NonNull String url) throws IOException {
        String filePath = MDImageLoader.Scheme.ASSETS.crop(url);
        InputStream inputStream = this.mContext.getAssets().open(filePath);
        byte[] bytes = DefaultLoader.getBytes(inputStream);
        DefaultLoader.closeStream(inputStream);
        return bytes;
    }

    @Nullable
    private byte[] drawable(@NonNull String url) throws IOException {
        String drawableIdString = MDImageLoader.Scheme.DRAWABLE.crop(url);
        int drawableId = Integer.parseInt(drawableIdString);
        InputStream inputStream = this.mContext.getResources().openRawResource(drawableId);
        byte[] bytes = DefaultLoader.getBytes(inputStream);
        DefaultLoader.closeStream(inputStream);
        return bytes;
    }

    @Nullable
    private static byte[] getBytes(@NonNull InputStream inputStream) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((i = inputStream.read()) != -1) {
            out.write(i);
        }
        return out.toByteArray();
    }

    private static void closeStream(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

