/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.live;

import android.text.Editable;
import android.text.style.StyleSpan;
import com.yydcdut.markdown.live.EditLive;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.syntax.edit.EditFactory;
import com.yydcdut.markdown.utils.SyntaxUtils;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;

class StyleLive
extends EditLive {
    StyleLive() {
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        super.beforeTextChanged(s, start, before, after);
        if (before == 0 || this.mMarkdownConfiguration == null) {
            return;
        }
        String deleteString = s.subSequence(start, start + before).toString();
        String beforeString = null;
        String afterString = null;
        if (start > 0) {
            beforeString = s.subSequence(start - 1, start).toString();
        }
        if (start + before + 1 <= s.length()) {
            afterString = s.subSequence(start + before, start + before + 1).toString();
        }
        if (SyntaxUtils.isNeedFormat("*", deleteString, beforeString, afterString) || SyntaxUtils.isNeedFormat("_", deleteString, beforeString, afterString)) {
            this.shouldFormat = true;
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mMarkdownConfiguration == null || !(s instanceof Editable)) {
            return;
        }
        if (this.shouldFormat) {
            this.format((Editable)s, start);
            return;
        }
        if (after == 0) {
            return;
        }
        String addString = s.subSequence(start, start + after > s.length() ? s.length() : start + after).toString();
        String beforeString = null;
        String afterString = null;
        if (start + 1 <= s.length()) {
            afterString = s.subSequence(start, start + 1).toString();
        }
        if (start > 0) {
            beforeString = s.subSequence(start - 1, start).toString();
        }
        if (SyntaxUtils.isNeedFormat("*", addString, beforeString, afterString) || SyntaxUtils.isNeedFormat("_", addString, beforeString, afterString)) {
            this.format((Editable)s, start);
        }
    }

    private void format(Editable editable, int start) {
        Utils.removeSpans(editable, start, StyleSpan.class);
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        Syntax syntax = EditFactory.create().getBoldSyntax(this.mMarkdownConfiguration);
        editTokenList.addAll(Utils.getMatchedEditTokenList(editable, syntax.format(editable), start));
        syntax = EditFactory.create().getItalicSyntax(this.mMarkdownConfiguration);
        editTokenList.addAll(Utils.getMatchedEditTokenList(editable, syntax.format(editable), start));
        Utils.setSpans(editable, editTokenList);
    }
}

