/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.live;

import android.support.annotation.NonNull;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.MarkdownEditText;
import com.yydcdut.markdown.live.BlockQuotesLive;
import com.yydcdut.markdown.live.CenterAlignLive;
import com.yydcdut.markdown.live.CodeBlockLive;
import com.yydcdut.markdown.live.CodeLive;
import com.yydcdut.markdown.live.HeaderLive;
import com.yydcdut.markdown.live.HorizontalRulesLive;
import com.yydcdut.markdown.live.IEditLive;
import com.yydcdut.markdown.live.ListLive;
import com.yydcdut.markdown.live.StrikeThroughLive;
import com.yydcdut.markdown.live.StyleLive;
import java.util.ArrayList;

public class LivePrepare {
    private boolean isConfig;
    private ArrayList<IEditLive> mEditControllerList;

    public LivePrepare(MarkdownEditText MarkdownEditText2, MarkdownEditText.EditTextWatcher editTextWatcher) {
        this.prepare(MarkdownEditText2, editTextWatcher);
    }

    private void prepare(MarkdownEditText MarkdownEditText2, MarkdownEditText.EditTextWatcher editTextWatcher) {
        this.mEditControllerList = new ArrayList();
        this.mEditControllerList.add(new BlockQuotesLive());
        this.mEditControllerList.add(new StyleLive());
        this.mEditControllerList.add(new CenterAlignLive());
        this.mEditControllerList.add(new HeaderLive());
        this.mEditControllerList.add(new HorizontalRulesLive(MarkdownEditText2));
        this.mEditControllerList.add(new CodeLive());
        this.mEditControllerList.add(new StrikeThroughLive());
        this.mEditControllerList.add(new ListLive(MarkdownEditText2, editTextWatcher));
        this.mEditControllerList.add(new CodeBlockLive());
    }

    public void config(@NonNull MarkdownConfiguration markdownConfiguration) {
        if (markdownConfiguration != null) {
            this.isConfig = true;
        }
        for (IEditLive controller : this.mEditControllerList) {
            controller.setMarkdownConfiguration(markdownConfiguration);
        }
    }

    public void onSelectionChanged(int selStart, int selEnd) {
        if (!this.isConfig) {
            return;
        }
        for (IEditLive iEditLive : this.mEditControllerList) {
            iEditLive.onSelectionChanged(selStart, selEnd);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        if (!this.isConfig) {
            return;
        }
        for (IEditLive iEditLive : this.mEditControllerList) {
            iEditLive.beforeTextChanged(s, start, before, after);
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int after) {
        if (!this.isConfig) {
            return;
        }
        for (IEditLive iEditLive : this.mEditControllerList) {
            iEditLive.onTextChanged(s, start, before, after);
        }
    }
}

