/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.live;

import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.MarkdownEditText;
import com.yydcdut.markdown.live.EditLive;
import com.yydcdut.markdown.span.MDOrderListSpan;
import com.yydcdut.markdown.span.MDUnOrderListSpan;
import com.yydcdut.markdown.utils.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ListLive
extends EditLive {
    private MarkdownEditText mMarkdownEditText;
    private MarkdownEditText.EditTextWatcher mTextWatcher;
    private MarkdownConfiguration mMarkdownConfiguration;
    private boolean mNeedFormat;

    public ListLive(MarkdownEditText MarkdownEditText2, MarkdownEditText.EditTextWatcher textWatcher) {
        this.mMarkdownEditText = MarkdownEditText2;
        this.mTextWatcher = textWatcher;
    }

    @Override
    public void setMarkdownConfiguration(@Nullable MarkdownConfiguration markdownConfiguration) {
        this.mMarkdownConfiguration = markdownConfiguration;
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mMarkdownConfiguration == null || !(s instanceof Editable)) {
            return;
        }
        Editable editable = (Editable)s;
        if (ListLive.checkLineDelete(editable, start, before, after)) {
            int beforeLinePosition = Utils.findBeforeNewLineChar((CharSequence)editable, start - 1) + 1;
            MDOrderListSpan mdBeginOrderListSpan = ListLive.getOrderListSpan(editable, beforeLinePosition, true);
            MDOrderListSpan mdEndOrderListSpan = ListLive.getOrderListSpan(editable, start + 1, true);
            MDUnOrderListSpan mdBeginUnOrderListSpan = ListLive.getUnOrderListSpan(editable, beforeLinePosition, true);
            MDUnOrderListSpan mdEndUnOrderListSpan = ListLive.getUnOrderListSpan(editable, start + 1, true);
            if (mdBeginOrderListSpan != null) {
                int spanStart = editable.getSpanStart((Object)mdBeginOrderListSpan);
                int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start + 1);
                if (mdEndOrderListSpan != null) {
                    editable.removeSpan((Object)mdEndOrderListSpan);
                }
                editable.removeSpan((Object)mdBeginOrderListSpan);
                editable.setSpan((Object)new MDOrderListSpan(10, mdBeginOrderListSpan.getNested(), mdBeginOrderListSpan.getNumber()), spanStart, position, 18);
            } else if (mdBeginUnOrderListSpan != null) {
                int spanStart = editable.getSpanStart((Object)mdBeginUnOrderListSpan);
                int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start + 1);
                if (mdEndUnOrderListSpan != null) {
                    editable.removeSpan((Object)mdEndUnOrderListSpan);
                }
                editable.removeSpan((Object)mdBeginUnOrderListSpan);
                editable.setSpan((Object)new MDUnOrderListSpan(10, mdBeginUnOrderListSpan.getColor(), mdBeginUnOrderListSpan.getNested(), mdBeginUnOrderListSpan.getType()), spanStart, position, 18);
            }
        } else {
            this.mNeedFormat = ListLive.checkDeleteOrderListSpan(editable, start, before, after);
            this.mNeedFormat |= ListLive.checkDeleteUnOrderListSpan(editable, start, before, after);
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mMarkdownConfiguration == null || !(s instanceof Editable)) {
            return;
        }
        Editable editable = (Editable)s;
        if (ListLive.checkNewLineInput(editable, start, before, after)) {
            MDOrderListSpan mdOrderListSpan = ListLive.getOrderListSpan(editable, start, false);
            MDUnOrderListSpan mdUnOrderListSpan = ListLive.getUnOrderListSpan(editable, start, false);
            if (mdOrderListSpan != null) {
                int startOfSpan = editable.getSpanStart((Object)mdOrderListSpan);
                int endOfSpan = editable.getSpanEnd((Object)mdOrderListSpan);
                int nested = mdOrderListSpan.getNested();
                if (endOfSpan - startOfSpan > ". ".length() + String.valueOf(mdOrderListSpan.getNumber()).length() + nested + 1) {
                    ListLive.updateOrderListSpanBeforeNewLine(editable, start, mdOrderListSpan, false);
                    this.insertOrderList(editable, mdOrderListSpan, start);
                } else {
                    this.deleteOrderListByEnter(editable, mdOrderListSpan, start, before, after, nested, startOfSpan, endOfSpan);
                }
            } else if (mdUnOrderListSpan != null) {
                int nested;
                int spanStart = editable.getSpanStart((Object)mdUnOrderListSpan);
                int spanEnd = editable.getSpanEnd((Object)mdUnOrderListSpan);
                if (spanEnd - spanStart > 3 + (nested = mdUnOrderListSpan.getNested())) {
                    ListLive.updateUnOrderListSpanBeforeNewLine(editable, start, mdUnOrderListSpan, false);
                    this.insertUnOrderList(editable, mdUnOrderListSpan, start);
                } else {
                    this.deleteUnOrderListByEnter(editable, mdUnOrderListSpan, start, before, after, nested, spanStart, spanEnd);
                }
            }
        } else if (ListLive.checkLineHeaderPosition(editable, start, before, after)) {
            this.updateLineHeaderList(editable, start, before, after);
        } else if (ListLive.isBeginningOfListSpan(editable, start, before, after) || this.mNeedFormat) {
            ListLive.updateListSpanBeginning(editable, start, before, after);
        } else if (ListLive.isSatisfiedOrderListFormat(editable, start)) {
            ListLive.formatOrderList(editable, start);
        }
    }

    @Override
    public void onSelectionChanged(int selStart, int selEnd) {
    }

    private static String getUnOderListNestedString(int nested, int type) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nested; ++i) {
            sb.append(" ");
        }
        switch (type) {
            case 0: {
                sb.append("* ");
                break;
            }
            case 1: {
                sb.append("- ");
                break;
            }
            case 2: {
                sb.append("+ ");
            }
        }
        return sb.toString();
    }

    private static String getOrderListNestedString(int nested, int number) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nested; ++i) {
            sb.append(" ");
        }
        sb.append(String.valueOf(number + 1));
        sb.append(". ");
        return sb.toString();
    }

    private void deleteUnOrderListByEnter(Editable editable, MDUnOrderListSpan mdUnOrderListSpan, int start, int before, int after, int nested, int spanStart, int spanEnd) {
        if (nested == 0) {
            editable.removeSpan((Object)mdUnOrderListSpan);
            this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start, spanEnd - spanStart, 0);
            editable.delete(spanStart, spanEnd);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, start, spanEnd - spanStart, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
        } else {
            ListLive.updateUnOrderListSpanBeforeNewLine(editable, start, mdUnOrderListSpan, true);
            this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start + after - 1, 1, 0);
            editable.delete(start + after - 1, start + after);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, start + after - 1, 1, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, spanStart, 1, 0);
            editable.delete(spanStart, spanStart + 1);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, spanStart, 1, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
        }
    }

    private void deleteOrderListByEnter(Editable editable, MDOrderListSpan mdOrderListSpan, int start, int before, int after, int nested, int spanStart, int spanEnd) {
        if (nested == 0) {
            editable.removeSpan((Object)mdOrderListSpan);
            this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start, spanEnd - spanStart, 0);
            editable.delete(spanStart, spanEnd);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, start, spanEnd - spanStart, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
        } else {
            ListLive.updateOrderListSpanBeforeNewLine(editable, start, mdOrderListSpan, true);
            this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start + after - 1, 1, 0);
            editable.delete(start + after - 1, start + after);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, start + after - 1, 1, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, spanStart, 1, 0);
            editable.delete(spanStart, spanStart + 1);
            this.mTextWatcher.doOnTextChanged((CharSequence)editable, spanStart, 1, 0);
            this.mTextWatcher.doAfterTextChanged(editable);
            this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
        }
    }

    private void insertOrderList(Editable editable, MDOrderListSpan mdOrderListSpan, int start) {
        this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
        String appendString = ListLive.getOrderListNestedString(mdOrderListSpan.getNested(), mdOrderListSpan.getNumber());
        this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start + 1, 0, appendString.length());
        editable.insert(start + 1, (CharSequence)appendString);
        int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start + appendString.length());
        editable.setSpan((Object)new MDOrderListSpan(10, mdOrderListSpan.getNested(), mdOrderListSpan.getNumber() + 1), start + 1, position == -1 ? start + 1 + appendString.length() : position, 18);
        this.mTextWatcher.doOnTextChanged((CharSequence)editable, start + 1, 0, appendString.length());
        this.mTextWatcher.doAfterTextChanged(editable);
        this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
    }

    private void insertUnOrderList(Editable editable, MDUnOrderListSpan mdUnOrderListSpan, int start) {
        this.mMarkdownEditText.removeTextChangedListener(this.mTextWatcher);
        String appendString = ListLive.getUnOderListNestedString(mdUnOrderListSpan.getNested(), mdUnOrderListSpan.getType());
        this.mTextWatcher.doBeforeTextChanged((CharSequence)editable, start + 1, 0, appendString.length());
        editable.insert(start + 1, (CharSequence)appendString);
        int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start + appendString.length());
        editable.setSpan((Object)new MDUnOrderListSpan(10, mdUnOrderListSpan.getColor(), mdUnOrderListSpan.getNested(), mdUnOrderListSpan.getType()), start + 1, position == -1 ? start + 1 + appendString.length() : position, 18);
        this.mTextWatcher.doOnTextChanged((CharSequence)editable, start + 1, 0, appendString.length());
        this.mTextWatcher.doAfterTextChanged(editable);
        this.mMarkdownEditText.addTextChangedListener(this.mTextWatcher);
    }

    private static boolean checkNewLineInput(Editable editable, int start, int before, int after) {
        if (after != 1 || before != 0 || start >= editable.length()) {
            return false;
        }
        return editable.charAt(start) == '\n';
    }

    private static boolean checkLineDelete(Editable editable, int start, int before, int after) {
        if (before != 1 || after != 0) {
            return false;
        }
        return editable.charAt(start) == '\n';
    }

    private static boolean checkLineHeaderPosition(Editable editable, int start, int before, int after) {
        if (start == 0 || Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1 == start) {
            int end = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
            if (ListLive.getOrderListSpan(editable, start, true) != null || ListLive.getUnOrderListSpan(editable, start, true) != null || ListLive.getOrderListSpan(editable, start + 1 > end ? start : end, true) != null || ListLive.getUnOrderListSpan(editable, start + 1 > end ? start : end, true) != null) {
                return false;
            }
            boolean bool = ListLive.isUnOrderList((CharSequence)editable, start, false);
            if (bool) {
                return bool;
            }
            return ListLive.isOrderList((CharSequence)editable, start, false);
        }
        return false;
    }

    private void updateLineHeaderList(Editable editable, int start, int before, int after) {
        int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        int nested = ListLive.calculateNested((CharSequence)editable, start, 0);
        if (nested == -1) {
            return;
        }
        if (ListLive.isOrderList((CharSequence)editable, start, false)) {
            int number = ListLive.calculateOrderListNumber((CharSequence)editable, start, 0);
            editable.setSpan((Object)new MDOrderListSpan(10, nested, number), start, position, 18);
        } else if (ListLive.isUnOrderList((CharSequence)editable, start, false)) {
            int type = ListLive.getUnOrderListType((CharSequence)editable, start);
            editable.setSpan((Object)new MDUnOrderListSpan(10, this.mMarkdownConfiguration.getUnOrderListColor(), nested, type), start, position, 18);
        }
    }

    @Nullable
    private static MDOrderListSpan getOrderListSpan(Editable editable, int start, boolean beginning) {
        MDOrderListSpan[] mdOrderListSpans = beginning ? (MDOrderListSpan[])editable.getSpans(start, start + 1, MDOrderListSpan.class) : (MDOrderListSpan[])editable.getSpans(start - 1, start, MDOrderListSpan.class);
        if (mdOrderListSpans != null && mdOrderListSpans.length > 0) {
            return mdOrderListSpans[0];
        }
        return null;
    }

    private static void updateOrderListSpanBeforeNewLine(Editable editable, int start, MDOrderListSpan mdOrderListSpan, boolean nestedDecrease) {
        int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        int startSpan = editable.getSpanStart((Object)mdOrderListSpan);
        int endSpan = editable.getSpanEnd((Object)mdOrderListSpan);
        if (endSpan <= position) {
            return;
        }
        editable.removeSpan((Object)mdOrderListSpan);
        int nested = mdOrderListSpan.getNested();
        if (nestedDecrease && nested > 0) {
            --nested;
        }
        editable.setSpan((Object)new MDOrderListSpan(10, nested, mdOrderListSpan.getNumber()), startSpan, position, 18);
    }

    private static void updateUnOrderListSpanBeforeNewLine(Editable editable, int start, MDUnOrderListSpan mdUnOrderListSpan, boolean nestedDecrease) {
        int position = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        int startSpan = editable.getSpanStart((Object)mdUnOrderListSpan);
        int endSpan = editable.getSpanEnd((Object)mdUnOrderListSpan);
        if (endSpan <= position) {
            return;
        }
        editable.removeSpan((Object)mdUnOrderListSpan);
        int nested = mdUnOrderListSpan.getNested();
        if (nestedDecrease && nested > 0) {
            --nested;
        }
        editable.setSpan((Object)new MDUnOrderListSpan(10, mdUnOrderListSpan.getColor(), nested, mdUnOrderListSpan.getType()), startSpan, position, 18);
    }

    @Nullable
    private static MDUnOrderListSpan getUnOrderListSpan(Editable editable, int start, boolean beginning) {
        MDUnOrderListSpan[] mdUnOrderListSpans = beginning ? (MDUnOrderListSpan[])editable.getSpans(start, start + 1, MDUnOrderListSpan.class) : (MDUnOrderListSpan[])editable.getSpans(start - 1, start, MDUnOrderListSpan.class);
        if (mdUnOrderListSpans != null && mdUnOrderListSpans.length > 0) {
            return mdUnOrderListSpans[0];
        }
        return null;
    }

    private static boolean isBeginningOfListSpan(Editable editable, int start, int before, int after) {
        int spanStart;
        if (before - after > 0) {
            return false;
        }
        MDOrderListSpan mdOrderListSpan = ListLive.getOrderListBeginning(editable, start, before, after);
        MDUnOrderListSpan mdUnOrderListSpan = ListLive.getUnOrderListBeginning(editable, start, before, after);
        return mdOrderListSpan != null ? start <= (spanStart = editable.getSpanStart((Object)mdOrderListSpan)) || start >= spanStart && start <= spanStart + mdOrderListSpan.getNested() + String.valueOf(mdOrderListSpan.getNumber()).length() + 2 : mdUnOrderListSpan != null && (start <= (spanStart = editable.getSpanStart((Object)mdUnOrderListSpan)) || start >= spanStart && start <= spanStart + mdUnOrderListSpan.getNested() + 2);
    }

    @Nullable
    private static MDOrderListSpan getOrderListBeginning(Editable editable, int start, int before, int after) {
        if (before != 0) {
            MDOrderListSpan[] mdOrderListSpans = (MDOrderListSpan[])editable.getSpans(start, start, MDOrderListSpan.class);
            if (mdOrderListSpans != null && mdOrderListSpans.length > 0) {
                return mdOrderListSpans[0];
            }
            return null;
        }
        if (start + 1 > editable.length()) {
            return null;
        }
        int addNumber = Math.abs(after - before);
        MDOrderListSpan[] mdOrderListSpans = (MDOrderListSpan[])editable.getSpans(start + addNumber, start + addNumber + 1, MDOrderListSpan.class);
        if (mdOrderListSpans != null && mdOrderListSpans.length > 0) {
            return mdOrderListSpans[0];
        }
        return null;
    }

    @Nullable
    private static MDUnOrderListSpan getUnOrderListBeginning(Editable editable, int start, int before, int after) {
        if (before != 0) {
            MDUnOrderListSpan[] mdUnOrderListSpans = (MDUnOrderListSpan[])editable.getSpans(start, start, MDUnOrderListSpan.class);
            if (mdUnOrderListSpans != null && mdUnOrderListSpans.length > 0) {
                return mdUnOrderListSpans[0];
            }
            return null;
        }
        if (start + 1 > editable.length()) {
            return null;
        }
        MDUnOrderListSpan[] mdUnOrderListSpans = (MDUnOrderListSpan[])editable.getSpans(start, start + after + 1, MDUnOrderListSpan.class);
        if (mdUnOrderListSpans != null && mdUnOrderListSpans.length > 0) {
            return mdUnOrderListSpans[0];
        }
        return null;
    }

    private static void updateListSpanBeginning(Editable editable, int start, int before, int after) {
        MDOrderListSpan mdOrderListSpan = ListLive.getOrderListBeginning(editable, start, before, after);
        MDUnOrderListSpan mdUnOrderListSpan = ListLive.getUnOrderListBeginning(editable, start, before, after);
        if (mdOrderListSpan != null) {
            int spanEnd = editable.getSpanEnd((Object)mdOrderListSpan);
            int position = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
            if (!ListLive.isOrderList((CharSequence)editable, position, false)) {
                editable.removeSpan((Object)mdOrderListSpan);
                return;
            }
            int nested = ListLive.calculateNested((CharSequence)editable, position, 0);
            if (nested == -1) {
                return;
            }
            editable.removeSpan((Object)mdOrderListSpan);
            int number = ListLive.calculateOrderListNumber((CharSequence)editable, position + nested, 0);
            editable.setSpan((Object)new MDOrderListSpan(10, nested, number), position, spanEnd, 18);
        } else if (mdUnOrderListSpan != null) {
            int spanEnd = editable.getSpanEnd((Object)mdUnOrderListSpan);
            int position = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
            if (!ListLive.isUnOrderList((CharSequence)editable, position, false)) {
                editable.removeSpan((Object)mdUnOrderListSpan);
                return;
            }
            int nested = ListLive.calculateNested((CharSequence)editable, position, 0);
            if (nested == -1) {
                return;
            }
            editable.removeSpan((Object)mdUnOrderListSpan);
            editable.setSpan((Object)new MDUnOrderListSpan(10, mdUnOrderListSpan.getColor(), nested, mdUnOrderListSpan.getType()), position, spanEnd, 18);
        }
    }

    private static int calculateNested(CharSequence s, int next, int currentNested) {
        if (next + 1 > s.length()) {
            return -1;
        }
        if (s.charAt(next) == ' ') {
            return ListLive.calculateNested(s, next + 1, currentNested + 1);
        }
        return currentNested;
    }

    private static int calculateOrderListNumber(CharSequence s, int next, int number) {
        if (next + 1 > s.length()) {
            return number;
        }
        CharSequence cs = s.subSequence(next, next + 1);
        if (TextUtils.isDigitsOnly((CharSequence)cs)) {
            number = number * 10 + Integer.parseInt(String.valueOf(cs));
            return ListLive.calculateOrderListNumber(s, next + 1, number);
        }
        if (" ".equals(cs)) {
            return ListLive.calculateOrderListNumber(s, next + 1, number);
        }
        return number;
    }

    private static boolean isOrderList(CharSequence s, int next, boolean isNumber) {
        if (next + 1 > s.length()) {
            return false;
        }
        char c = s.charAt(next);
        if (isNumber) {
            if (Character.isDigit(c)) {
                return ListLive.isOrderList(s, next + 1, true);
            }
            return c == '.';
        }
        if (c == ' ') {
            return ListLive.isOrderList(s, next + 1, false);
        }
        if (Character.isDigit(c)) {
            return ListLive.isOrderList(s, next + 1, true);
        }
        return false;
    }

    private static boolean isUnOrderList(CharSequence s, int next, boolean hasKey) {
        if (next + 1 > s.length()) {
            return false;
        }
        if (hasKey) {
            char c = s.charAt(next);
            return c == ' ';
        }
        char c = s.charAt(next);
        if (c == '+' || c == '-' || c == '*') {
            return ListLive.isUnOrderList(s, next + 1, true);
        }
        if (c == ' ') {
            return ListLive.isUnOrderList(s, next + 1, false);
        }
        return false;
    }

    private static int getUnOrderListType(CharSequence s, int next) {
        if (next + 1 > s.length()) {
            return 0;
        }
        char c = s.charAt(next);
        if (c == '+') {
            return 2;
        }
        if (c == '-') {
            return 1;
        }
        if (c == '*') {
            return 0;
        }
        if (c == ' ') {
            return ListLive.getUnOrderListType(s, next + 1);
        }
        return 0;
    }

    private static boolean isSatisfiedOrderListFormat(Editable editable, int start) {
        int endPosition;
        int startPosition = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        MDOrderListSpan[] mdOrderListSpans = (MDOrderListSpan[])editable.getSpans(startPosition, endPosition = Utils.findNextNewLineCharCompat((CharSequence)editable, start), MDOrderListSpan.class);
        if (mdOrderListSpans != null && mdOrderListSpans.length > 0) {
            return false;
        }
        CharSequence charSequence = editable.subSequence(startPosition, endPosition);
        Pattern p = Pattern.compile("^( *)(\\d+)\\. (.*?)$");
        Matcher m = p.matcher(charSequence);
        return m.matches();
    }

    private static void formatOrderList(Editable editable, int start) {
        int startPosition = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        int endPosition = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        int nested = ListLive.calculateNested((CharSequence)editable, startPosition, 0);
        int number = ListLive.calculateOrderListNumber((CharSequence)editable, startPosition + nested, 0);
        editable.setSpan((Object)new MDOrderListSpan(10, nested, number), startPosition, endPosition, 18);
    }

    private static boolean checkDeleteOrderListSpan(Editable editable, int start, int before, int after) {
        if (before == 0) {
            return false;
        }
        MDOrderListSpan mdOrderListSpan = ListLive.getOrderListSpan(editable, start, true);
        if (mdOrderListSpan == null) {
            return false;
        }
        int position = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        int totalPosition = position + mdOrderListSpan.getNested() + String.valueOf(mdOrderListSpan.getNumber()).length() + " ".length();
        return totalPosition >= start || start <= position;
    }

    private static boolean checkDeleteUnOrderListSpan(Editable editable, int start, int before, int after) {
        if (before == 0) {
            return false;
        }
        MDUnOrderListSpan mdUnOrderListSpan = ListLive.getUnOrderListSpan(editable, start, true);
        if (mdUnOrderListSpan == null) {
            return false;
        }
        int position = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        int totalPosition = position + mdUnOrderListSpan.getNested() + "* ".length();
        return totalPosition >= start || start <= position;
    }
}

