/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.live;

import android.graphics.Color;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.style.ForegroundColorSpan;
import com.yydcdut.markdown.MarkdownEditText;
import com.yydcdut.markdown.live.EditLive;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDHorizontalRulesSpan;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.syntax.edit.EditFactory;
import com.yydcdut.markdown.utils.SyntaxUtils;
import com.yydcdut.markdown.utils.Utils;
import java.util.List;

class HorizontalRulesLive
extends EditLive {
    private MarkdownEditText mMarkdownEditText;

    public HorizontalRulesLive(@NonNull MarkdownEditText MarkdownEditText2) {
        this.mMarkdownEditText = MarkdownEditText2;
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        super.beforeTextChanged(s, start, before, after);
        if (before == 0 || this.mMarkdownConfiguration == null) {
            return;
        }
        String deleteString = s.subSequence(start, start + before).toString();
        String beforeString = null;
        String afterString = null;
        if (start > 0) {
            beforeString = s.subSequence(start - 1, start).toString();
        }
        if (start + before + 1 <= s.length()) {
            afterString = s.subSequence(start + before, start + before + 1).toString();
        }
        if (SyntaxUtils.isNeedFormat("_", deleteString, beforeString, afterString) || SyntaxUtils.isNeedFormat("*", deleteString, beforeString, afterString)) {
            this.shouldFormat = true;
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mMarkdownConfiguration == null || !(s instanceof Editable)) {
            return;
        }
        if (this.shouldFormat) {
            this.format((Editable)s, start);
            return;
        }
        if (after == 0) {
            return;
        }
        String beforeString = null;
        String afterString = null;
        String addString = s.subSequence(start, start + after).toString();
        if (start + 1 <= s.length()) {
            afterString = s.subSequence(start, start + 1).toString();
        }
        if (start > 0) {
            beforeString = s.subSequence(start - 1, start).toString();
        }
        if (SyntaxUtils.isNeedFormat("_", addString, beforeString, afterString) || SyntaxUtils.isNeedFormat("*", addString, beforeString, afterString)) {
            this.format((Editable)s, start);
        }
    }

    private void format(Editable editable, int start) {
        Utils.removeSpans(editable, start, MDHorizontalRulesSpan.class);
        Syntax syntax = EditFactory.create().getHorizontalRulesSyntax(this.mMarkdownConfiguration);
        List<EditToken> editTokenList = Utils.getMatchedEditTokenList(editable, syntax.format(editable), start);
        Utils.setSpans(editable, editTokenList);
    }

    @Override
    public void onSelectionChanged(int selStart, int selEnd) {
        this.setAllHorizontalRulesTextColor();
        this.removeCurrentHorizontalRulesTextColor(selStart, selEnd);
    }

    private void setAllHorizontalRulesTextColor() {
        Editable editable = this.mMarkdownEditText.getText();
        MDHorizontalRulesSpan[] spans = (MDHorizontalRulesSpan[])editable.getSpans(0, editable.length(), MDHorizontalRulesSpan.class);
        if (spans.length > 0) {
            for (MDHorizontalRulesSpan span : spans) {
                int end;
                int start = editable.getSpanStart((Object)span);
                if (this.existForegroundColorSpan(start, end = editable.getSpanEnd((Object)span))) continue;
                int textColor = this.mMarkdownEditText.getCurrentTextColor();
                editable.setSpan((Object)new ForegroundColorSpan(Color.argb((int)51, (int)Color.red((int)textColor), (int)Color.green((int)textColor), (int)Color.blue((int)textColor))), start, end, 33);
            }
        }
    }

    private void removeCurrentHorizontalRulesTextColor(int selStart, int selEnd) {
        Editable editable = this.mMarkdownEditText.getText();
        MDHorizontalRulesSpan[] spans = (MDHorizontalRulesSpan[])editable.getSpans(selStart, selEnd, MDHorizontalRulesSpan.class);
        if (spans == null || spans.length == 0) {
            return;
        }
        for (MDHorizontalRulesSpan span : spans) {
            ForegroundColorSpan[] foregroundColorSpans;
            int start = editable.getSpanStart((Object)span);
            int end = editable.getSpanEnd((Object)span);
            for (ForegroundColorSpan foregroundColorSpan : foregroundColorSpans = (ForegroundColorSpan[])editable.getSpans(start, end, ForegroundColorSpan.class)) {
                editable.removeSpan((Object)foregroundColorSpan);
            }
        }
    }

    private boolean existForegroundColorSpan(int start, int end) {
        ForegroundColorSpan[] foregroundColorSpans = (ForegroundColorSpan[])this.mMarkdownEditText.getText().getSpans(start, end, ForegroundColorSpan.class);
        return foregroundColorSpans != null ? foregroundColorSpans.length != 0 : false;
    }
}

