/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.live;

import android.text.Editable;
import android.text.style.AlignmentSpan;
import com.yydcdut.markdown.live.EditLive;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.syntax.edit.EditFactory;
import com.yydcdut.markdown.utils.Utils;
import java.util.List;

class CenterAlignLive
extends EditLive {
    CenterAlignLive() {
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        super.beforeTextChanged(s, start, before, after);
        if (before == 0 || this.mMarkdownConfiguration == null) {
            return;
        }
        if (this.isNeedFormat(s.subSequence(start, start + before).toString())) {
            this.shouldFormat = true;
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mMarkdownConfiguration == null || !(s instanceof Editable)) {
            return;
        }
        if (this.shouldFormat) {
            this.format((Editable)s, start);
            return;
        }
        if (after == 0) {
            return;
        }
        if (this.isNeedFormat(s.subSequence(start, start + after).toString())) {
            this.format((Editable)s, start);
        }
    }

    private void format(Editable editable, int start) {
        Utils.removeSpans(editable, start, AlignmentSpan.Standard.class);
        Syntax syntax = EditFactory.create().getCenterAlignSyntax(this.mMarkdownConfiguration);
        List<EditToken> editTokenList = Utils.getMatchedEditTokenList(editable, syntax.format(editable), start);
        Utils.setSpans(editable, editTokenList);
    }

    private boolean isNeedFormat(String string) {
        return string.contains("[") || string.contains("]");
    }
}

