/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class ForwardingDrawable
extends Drawable
implements Drawable.Callback {
    private Drawable mCurrentDelegate;

    public ForwardingDrawable(Drawable drawable) {
        this.mCurrentDelegate = drawable;
    }

    public void draw(Canvas canvas) {
        this.mCurrentDelegate.draw(canvas);
    }

    public void setAlpha(int alpha) {
        this.mCurrentDelegate.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mCurrentDelegate.setColorFilter(colorFilter);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        super.setVisible(visible, restart);
        return this.mCurrentDelegate.setVisible(visible, restart);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mCurrentDelegate.setBounds(bounds);
    }

    public boolean isStateful() {
        return this.mCurrentDelegate.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        return this.mCurrentDelegate.setState(state);
    }

    protected boolean onLevelChange(int level) {
        return this.mCurrentDelegate.setLevel(level);
    }

    public int getOpacity() {
        return this.mCurrentDelegate.getOpacity();
    }

    public Drawable setCurrent(Drawable newDelegate) {
        Drawable previousDelegate = this.setCurrentWithoutInvalidate(newDelegate);
        this.invalidateSelf();
        return previousDelegate;
    }

    private Drawable setCurrentWithoutInvalidate(Drawable newDelegate) {
        Drawable previousDelegate = this.mCurrentDelegate;
        ForwardingDrawable.copyProperties(newDelegate, previousDelegate);
        this.mCurrentDelegate = newDelegate;
        return previousDelegate;
    }

    public void refreshCurrent(Drawable newDelegate) {
        if (newDelegate == null || this.mCurrentDelegate == null || newDelegate == this.mCurrentDelegate) {
            return;
        }
        Drawable previousDelegate = this.mCurrentDelegate;
        ForwardingDrawable.copyProperties(previousDelegate, newDelegate);
        this.mCurrentDelegate = newDelegate;
        this.invalidateSelf();
    }

    private static void copyProperties(Drawable to, Drawable from) {
        if (from == null || to == null || to == from) {
            return;
        }
        to.setBounds(from.getBounds());
        to.setChangingConfigurations(from.getChangingConfigurations());
        to.setLevel(from.getLevel());
        to.setVisible(from.isVisible(), false);
        to.setState(from.getState());
    }

    public int getIntrinsicWidth() {
        return this.mCurrentDelegate.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mCurrentDelegate.getIntrinsicHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mCurrentDelegate.getPadding(padding);
    }

    public Drawable mutate() {
        this.mCurrentDelegate.mutate();
        return this;
    }

    public Drawable getCurrent() {
        return this.mCurrentDelegate;
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }
}

