/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.chain;

import android.support.annotation.NonNull;
import com.yydcdut.markdown.chain.ISpecialChain;
import com.yydcdut.markdown.syntax.Syntax;
import java.util.ArrayList;
import java.util.List;

public class SyntaxMultiChains
implements ISpecialChain {
    private Syntax mSyntax;
    private List<ISpecialChain> mNextHandleSyntaxList = null;

    public SyntaxMultiChains(@NonNull Syntax syntax) {
        this.mSyntax = syntax;
    }

    @Override
    @NonNull
    public boolean handleSyntax(@NonNull CharSequence charSequence) {
        if (this.mSyntax.isMatch(charSequence)) {
            this.mSyntax.format(charSequence);
        }
        if (this.mNextHandleSyntaxList != null) {
            boolean handled = false;
            for (ISpecialChain responsibilityChain : this.mNextHandleSyntaxList) {
                handled |= responsibilityChain.handleSyntax(charSequence);
            }
            return handled;
        }
        return false;
    }

    @Override
    public boolean addNextHandleSyntax(@NonNull ISpecialChain nextHandleSyntax) {
        if (this.mNextHandleSyntaxList == null) {
            this.mNextHandleSyntaxList = new ArrayList<ISpecialChain>();
        }
        this.mNextHandleSyntaxList.add(nextHandleSyntax);
        return true;
    }

    @Override
    @Deprecated
    public boolean setNextHandleSyntax(@NonNull ISpecialChain nextHandleSyntax) {
        return false;
    }
}

