/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.yydcdut.markdown.span.MDImageSpan;

public class MarkdownTextView
extends TextView {
    private boolean mHasImageInText;

    public MarkdownTextView(Context context) {
        super(context);
    }

    public MarkdownTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MarkdownTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mHasImageInText) {
            this.onDetach();
            this.mHasImageInText = false;
        }
        if (text instanceof Spanned) {
            MDImageSpan[] spans = (MDImageSpan[])((Spanned)text).getSpans(0, text.length(), MDImageSpan.class);
            this.mHasImageInText = spans.length > 0;
            for (MDImageSpan image : spans) {
                image.onAttach((View)this);
            }
        }
        super.setText(text, type);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void invalidateDrawable(Drawable dr) {
        if (this.mHasImageInText) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    final void onDetach() {
        MDImageSpan[] images;
        for (MDImageSpan image : images = this.getImages()) {
            Drawable drawable = image.getDrawable();
            if (drawable != null) {
                this.unscheduleDrawable(drawable);
            }
            image.onDetach();
        }
    }

    private MDImageSpan[] getImages() {
        if (this.mHasImageInText && this.length() > 0) {
            return (MDImageSpan[])((Spanned)this.getText()).getSpans(0, this.length(), MDImageSpan.class);
        }
        return new MDImageSpan[0];
    }
}

