/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown;

import android.content.Context;
import android.support.annotation.NonNull;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.MarkdownEditText;
import com.yydcdut.markdown.syntax.SyntaxFactory;

public class MarkdownProcessor {
    private Context context;
    private MarkdownConfiguration markdownConfiguration;
    private SyntaxFactory syntaxFactory;

    public MarkdownProcessor(Context context) {
        this.checkNULL(context);
        this.context = context;
    }

    public void config(MarkdownConfiguration markdownConfiguration) {
        this.markdownConfiguration = markdownConfiguration;
    }

    public void factory(SyntaxFactory syntaxFactory) {
        this.checkNULL(syntaxFactory);
        this.syntaxFactory = syntaxFactory;
    }

    public CharSequence parse(CharSequence charSequence) {
        MarkdownConfiguration config = this.getMarkdownConfiguration();
        return this.syntaxFactory.parse(charSequence, config);
    }

    public void live(MarkdownEditText editText) {
        editText.setFactoryAndConfig(this.syntaxFactory, this.getMarkdownConfiguration());
    }

    @NonNull
    private MarkdownConfiguration getMarkdownConfiguration() {
        if (this.markdownConfiguration == null) {
            this.markdownConfiguration = new MarkdownConfiguration.Builder(this.context).build();
        }
        return this.markdownConfiguration;
    }

    private void checkNULL(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("" + o.getClass().getName() + " is NULL");
        }
    }
}

