/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.LivePrepare;
import com.yydcdut.markdown.span.MDImageSpan;
import com.yydcdut.markdown.syntax.SyntaxFactory;
import com.yydcdut.markdown.syntax.text.TextFactory;
import java.util.ArrayList;

public class MarkdownEditText
extends EditText
implements Handler.Callback {
    private static final String TAG = MarkdownEditText.class.getName();
    private static final int MSG_BEFORE_TEXT_CHANGED = 1;
    private static final int MSG_ON_TEXT_CHANGED = 2;
    private static final int MSG_AFTER_TEXT_CHANGED = 3;
    private static final int MSG_INIT_FORMAT = 4;
    private static final int MSG_FORMAT_BEFORE_TEXT_CHANGED = 5;
    private static final int MSG_FORMAT_ON_TEXT_CHANGED = 6;
    private Handler mHandler;
    private static final String BUNDLE_CHAR_SEQUENCE = "bundle_char_sequence";
    private static final String BUNDLE_START = "bundle_start";
    private static final String BUNDLE_BEFORE = "bundle_before";
    private static final String BUNDLE_AFTER = "bundle_after";
    private SyntaxFactory mGrammarFactory;
    private MarkdownConfiguration mMarkdownConfiguration;
    private ArrayList<TextWatcher> mListeners;
    private EditTextWatcher mEditTextWatcher;
    private boolean mHasImageInText;
    private boolean mInitFormat;
    private LivePrepare mLivePrepare;

    public MarkdownEditText(Context context) {
        super(context);
        this.init();
    }

    public MarkdownEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MarkdownEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mEditTextWatcher = new EditTextWatcher();
        this.mHandler = new Handler((Handler.Callback)this);
        this.mLivePrepare = new LivePrepare(this, this.mEditTextWatcher);
    }

    public void clear() {
        this.removeTextChangedListener(this.mEditTextWatcher);
        Editable editable = this.getText();
        int selectionEnd = this.getSelectionEnd();
        int selectionStart = this.getSelectionStart();
        this.setText(editable.toString());
        this.setSelection(selectionStart, selectionEnd);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (watcher == this.mEditTextWatcher) {
            super.addTextChangedListener(watcher);
        } else {
            if (this.mListeners == null) {
                this.mListeners = new ArrayList();
            }
            this.mListeners.add(watcher);
        }
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (watcher == this.mEditTextWatcher) {
            super.removeTextChangedListener(watcher);
        } else if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    private void sendBeforeTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(s, start, before, after);
            }
        }
    }

    private void beforeTextChanged4Controller(CharSequence s, int start, int before, int after) {
        this.mLivePrepare.beforeTextChanged(s, start, before, after);
    }

    private void sendOnTextChanged(CharSequence s, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(s, start, before, after);
            }
        }
    }

    private void onTextChanged4Controller(CharSequence s, int start, int before, int after) {
        this.mLivePrepare.onTextChanged(s, start, before, after);
    }

    private void sendAfterTextChanged(Editable s) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(s);
            }
        }
    }

    public void setFactoryAndConfig(@NonNull SyntaxFactory syntaxFactory, @NonNull MarkdownConfiguration markdownConfiguration) {
        this.mGrammarFactory = syntaxFactory;
        this.mMarkdownConfiguration = markdownConfiguration;
        this.mLivePrepare.config(markdownConfiguration);
        super.addTextChangedListener((TextWatcher)this.mEditTextWatcher);
        Editable editable = this.getText();
        if (!TextUtils.isEmpty((CharSequence)editable)) {
            this.mInitFormat = true;
            this.mEditTextWatcher.beforeTextChanged("", 0, 0, editable.length());
            this.mEditTextWatcher.onTextChanged((CharSequence)editable, 0, 0, editable.length());
            this.mEditTextWatcher.afterTextChanged(editable);
        }
    }

    private CharSequence format() {
        if (this.mGrammarFactory == null) {
            return this.getText();
        }
        Editable editable = this.getText();
        long begin = System.currentTimeMillis();
        CharSequence charSequence = this.mGrammarFactory.parse((CharSequence)editable, this.mMarkdownConfiguration);
        return charSequence;
    }

    private void setEditableText(CharSequence charSequence) {
        int selectionEnd = this.getSelectionEnd();
        int selectionStart = this.getSelectionStart();
        this.removeTextChangedListener(this.mEditTextWatcher);
        this.setText(charSequence);
        this.addTextChangedListener(this.mEditTextWatcher);
        this.setSelection(selectionStart, selectionEnd);
    }

    private boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Bundle bundle0 = msg.getData();
                CharSequence s0 = bundle0.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                int start0 = bundle0.getInt(BUNDLE_START);
                int before0 = bundle0.getInt(BUNDLE_BEFORE);
                int after0 = bundle0.getInt(BUNDLE_AFTER);
                this.sendBeforeTextChanged(s0, start0, before0, after0);
                break;
            }
            case 2: {
                Bundle bundle1 = msg.getData();
                CharSequence s1 = bundle1.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                int start1 = bundle1.getInt(BUNDLE_START);
                int before1 = bundle1.getInt(BUNDLE_BEFORE);
                int after1 = bundle1.getInt(BUNDLE_AFTER);
                this.sendOnTextChanged(s1, start1, before1, after1);
                break;
            }
            case 3: {
                Bundle bundle2 = msg.getData();
                CharSequence s2 = bundle2.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                if (s2 instanceof Editable) {
                    this.sendAfterTextChanged((Editable)s2);
                    break;
                }
                this.sendAfterTextChanged(this.getText());
                break;
            }
            case 4: {
                Bundle bundle3 = msg.getData();
                CharSequence s3 = bundle3.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                this.setEditableText(s3);
                break;
            }
            case 5: {
                Bundle bundle4 = msg.getData();
                CharSequence s4 = bundle4.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                int start4 = bundle4.getInt(BUNDLE_START);
                int before4 = bundle4.getInt(BUNDLE_BEFORE);
                int after4 = bundle4.getInt(BUNDLE_AFTER);
                this.beforeTextChanged4Controller(s4, start4, before4, after4);
                break;
            }
            case 6: {
                Bundle bundle5 = msg.getData();
                CharSequence s5 = bundle5.getCharSequence(BUNDLE_CHAR_SEQUENCE);
                int start5 = bundle5.getInt(BUNDLE_START);
                int before5 = bundle5.getInt(BUNDLE_BEFORE);
                int after5 = bundle5.getInt(BUNDLE_AFTER);
                this.onTextChanged4Controller(s5, start5, before5, after5);
                break;
            }
        }
        return false;
    }

    private void sendMessage(int what, CharSequence s, int start, int before, int after) {
        Message message = this.mHandler.obtainMessage();
        Bundle bundle = new Bundle();
        bundle.putCharSequence(BUNDLE_CHAR_SEQUENCE, s);
        bundle.putInt(BUNDLE_START, start);
        bundle.putInt(BUNDLE_BEFORE, before);
        bundle.putInt(BUNDLE_AFTER, after);
        message.what = what;
        message.setData(bundle);
        this.mHandler.sendMessage(message);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (this.mLivePrepare != null) {
            this.mLivePrepare.onSelectionChanged(selStart, selEnd);
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mGrammarFactory instanceof TextFactory) {
            if (this.mHasImageInText) {
                this.onDetach();
                this.mHasImageInText = false;
            }
            if (text instanceof Spanned) {
                MDImageSpan[] spans = (MDImageSpan[])((Spanned)text).getSpans(0, text.length(), MDImageSpan.class);
                this.mHasImageInText = spans.length > 0;
                for (MDImageSpan image : spans) {
                    image.onAttach((View)this);
                }
            }
        }
        super.setText(text, type);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    final void onAttach() {
        MDImageSpan[] images;
        for (MDImageSpan image : images = this.getImages()) {
            image.onAttach((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void invalidateDrawable(Drawable dr) {
        if (this.mGrammarFactory instanceof TextFactory && this.mHasImageInText) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    private void onDetach() {
        if (this.mGrammarFactory instanceof TextFactory) {
            MDImageSpan[] images;
            for (MDImageSpan image : images = this.getImages()) {
                Drawable drawable = image.getDrawable();
                if (drawable != null) {
                    this.unscheduleDrawable(drawable);
                }
                image.onDetach();
            }
        }
    }

    private MDImageSpan[] getImages() {
        if (this.mGrammarFactory instanceof TextFactory && this.mHasImageInText && this.length() > 0) {
            return (MDImageSpan[])this.getText().getSpans(0, this.length(), MDImageSpan.class);
        }
        return new MDImageSpan[0];
    }

    public class EditTextWatcher
    implements TextWatcher {
        public void doBeforeTextChanged(CharSequence s, int start, int before, int after) {
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendBeforeTextChanged(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(1, s, start, before, after);
            }
        }

        public void doOnTextChanged(CharSequence s, int start, int before, int after) {
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendOnTextChanged(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(2, s, start, before, after);
            }
        }

        public void doAfterTextChanged(Editable s) {
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendAfterTextChanged(MarkdownEditText.this.getText());
            } else {
                MarkdownEditText.this.sendMessage(3, (CharSequence)s, 0, 0, 0);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendBeforeTextChanged(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(1, s, start, before, after);
            }
            if (MarkdownEditText.this.mInitFormat) {
                return;
            }
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.beforeTextChanged4Controller(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(5, s, start, before, after);
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendOnTextChanged(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(2, s, start, before, after);
            }
            if (MarkdownEditText.this.mInitFormat) {
                return;
            }
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.onTextChanged4Controller(s, start, before, after);
            } else {
                MarkdownEditText.this.sendMessage(6, s, start, before, after);
            }
        }

        public void afterTextChanged(Editable s) {
            if (MarkdownEditText.this.mInitFormat) {
                CharSequence charSequence = MarkdownEditText.this.format();
                if (MarkdownEditText.this.isMainThread()) {
                    MarkdownEditText.this.setEditableText(charSequence);
                } else {
                    MarkdownEditText.this.sendMessage(4, charSequence, 0, 0, 0);
                }
                MarkdownEditText.this.mInitFormat = false;
            }
            if (MarkdownEditText.this.isMainThread()) {
                MarkdownEditText.this.sendAfterTextChanged(MarkdownEditText.this.getText());
            } else {
                MarkdownEditText.this.sendMessage(3, (CharSequence)s, 0, 0, 0);
            }
        }
    }
}

