/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.yydcdut.markdown.callback.OnLinkClickCallback;
import com.yydcdut.markdown.callback.OnTodoClickCallback;
import com.yydcdut.markdown.config.BlockQuote;
import com.yydcdut.markdown.config.Code;
import com.yydcdut.markdown.config.Header;
import com.yydcdut.markdown.config.HorizontalRule;
import com.yydcdut.markdown.config.Image;
import com.yydcdut.markdown.config.Link;
import com.yydcdut.markdown.config.Todo;
import com.yydcdut.markdown.config.UnOrderList;
import com.yydcdut.markdown.loader.MDImageLoader;
import com.yydcdut.markdown.theme.Theme;
import com.yydcdut.markdown.theme.ThemeDefault;
import java.util.List;

public class MarkdownConfiguration {
    private final Header header;
    private final BlockQuote blockQuote;
    private final HorizontalRule horizontalRule;
    private final Code code;
    private final Theme theme;
    private final Todo todo;
    private final UnOrderList unOrderList;
    private final Link link;
    private final Image image;

    protected MarkdownConfiguration(Header header, BlockQuote blockQuote, HorizontalRule horizontalRule, Code code, Theme theme, Todo _todo, UnOrderList unOrderList, Link link, Image image) {
        this.header = header;
        this.blockQuote = blockQuote;
        this.horizontalRule = horizontalRule;
        this.code = code;
        this.theme = theme;
        this.todo = _todo;
        this.unOrderList = unOrderList;
        this.link = link;
        this.image = image;
    }

    public final float getHeader1RelativeSize() {
        return this.header.h1;
    }

    public final float getHeader2RelativeSize() {
        return this.header.h2;
    }

    public final float getHeader3RelativeSize() {
        return this.header.h3;
    }

    public final float getHeader4RelativeSize() {
        return this.header.h4;
    }

    public final float getHeader5RelativeSize() {
        return this.header.h5;
    }

    public final float getHeader6RelativeSize() {
        return this.header.h6;
    }

    public final int getBlockQuotesLineColor() {
        return this.blockQuote.lineColor;
    }

    public final float getBlockQuoteRelativeSize() {
        return this.blockQuote.size;
    }

    public final List<Integer> getBlockQuoteBgColor() {
        return this.blockQuote.bgColorList;
    }

    public final int getHorizontalRulesColor() {
        return this.horizontalRule.color;
    }

    public int getHorizontalRulesHeight() {
        return this.horizontalRule.height;
    }

    public final int getCodeFontColor() {
        return this.code.color;
    }

    public final int getCodeBgColor() {
        return this.code.bgColor;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public final int getTodoColor() {
        return this.todo.todoColor;
    }

    public final int getTodoDoneColor() {
        return this.todo.doneColor;
    }

    public final OnTodoClickCallback getOnTodoClickCallback() {
        return this.todo.onTodoClickCallback;
    }

    public final int getUnOrderListColor() {
        return this.unOrderList.color;
    }

    public int getLinkFontColor() {
        return this.link.color;
    }

    public boolean isShowLinkUnderline() {
        return this.link.underline;
    }

    public OnLinkClickCallback getOnLinkClickCallback() {
        return this.link.callback;
    }

    public MDImageLoader getRxMDImageLoader() {
        return this.image.loader;
    }

    public final int[] getDefaultImageSize() {
        return this.image.defaultSize;
    }

    public static class Builder {
        private Header header = new Header();
        private BlockQuote blockQuote = new BlockQuote();
        private HorizontalRule horizontalRule = new HorizontalRule();
        private Code code = new Code();
        private Theme theme = new ThemeDefault();
        private Todo todo = new Todo();
        private UnOrderList unOrderList = new UnOrderList();
        private Link link = new Link();
        private Image image;

        public Builder(@NonNull Context context) {
            this.image = new Image(context);
        }

        public Builder setHeader1RelativeSize(float header1RelativeSize) {
            this.header.h1 = header1RelativeSize;
            return this;
        }

        public Builder setHeader2RelativeSize(float header2RelativeSize) {
            this.header.h2 = header2RelativeSize;
            return this;
        }

        public Builder setHeader3RelativeSize(float header3RelativeSize) {
            this.header.h3 = header3RelativeSize;
            return this;
        }

        public Builder setHeader4RelativeSize(float header4RelativeSize) {
            this.header.h4 = header4RelativeSize;
            return this;
        }

        public Builder setHeader5RelativeSize(float header5RelativeSize) {
            this.header.h5 = header5RelativeSize;
            return this;
        }

        public Builder setHeader6RelativeSize(float header6RelativeSize) {
            this.header.h6 = header6RelativeSize;
            return this;
        }

        public Builder setBlockQuotesLineColor(@ColorInt int lineColor) {
            this.blockQuote.lineColor = lineColor;
            return this;
        }

        public Builder setBlockQuotesBgColor(int bgColor, int ... nestBgColor) {
            this.blockQuote.bgColorList.set(0, bgColor);
            if (nestBgColor != null && nestBgColor.length > 0) {
                int count = nestBgColor.length;
                for (int i = 0; i < count; ++i) {
                    this.blockQuote.bgColorList.add(nestBgColor[i]);
                }
            }
            return this;
        }

        public Builder setBlockQuotesRelativeSize(float blockQuotesRelativeSize) {
            this.blockQuote.size = blockQuotesRelativeSize;
            return this;
        }

        public Builder setHorizontalRulesColor(@ColorInt int horizontalRulesColor) {
            this.horizontalRule.color = horizontalRulesColor;
            return this;
        }

        public Builder setHorizontalRulesHeight(int horizontalRulesHeight) {
            this.horizontalRule.height = horizontalRulesHeight;
            return this;
        }

        public Builder setCodeFontColor(@ColorInt int fontColor) {
            this.code.color = fontColor;
            return this;
        }

        public Builder setCodeBgColor(@ColorInt int codeBgColor) {
            this.code.bgColor = codeBgColor;
            return this;
        }

        public Builder setTheme(Theme theme) {
            this.theme = theme;
            return this;
        }

        public Builder setTodoColor(@ColorInt int todoColor) {
            this.todo.todoColor = todoColor;
            return this;
        }

        public Builder setTodoDoneColor(@ColorInt int todoDoneColor) {
            this.todo.doneColor = todoDoneColor;
            return this;
        }

        public Builder setOnTodoClickCallback(OnTodoClickCallback onTodoClickCallback) {
            this.todo.onTodoClickCallback = onTodoClickCallback;
            return this;
        }

        public Builder setUnOrderListColor(int unOrderListColor) {
            this.unOrderList.color = unOrderListColor;
            return this;
        }

        public Builder setLinkFontColor(int linkFontColor) {
            this.link.color = linkFontColor;
            return this;
        }

        public Builder showLinkUnderline(boolean show) {
            this.link.underline = show;
            return this;
        }

        public Builder setOnLinkClickCallback(OnLinkClickCallback onLinkClickCallback) {
            this.link.callback = onLinkClickCallback;
            return this;
        }

        public Builder setRxMDImageLoader(MDImageLoader MDImageLoader2) {
            this.image.loader = MDImageLoader2;
            return this;
        }

        public Builder setDefaultImageSize(int width, int height) {
            this.image.defaultSize = new int[]{width, height};
            return this;
        }

        public MarkdownConfiguration build() {
            return new MarkdownConfiguration(this.header, this.blockQuote, this.horizontalRule, this.code, this.theme, this.todo, this.unOrderList, this.link, this.image);
        }
    }
}

