/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.whisperlint;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.yy.mobile.whisperlint.support.api6.AnnotationCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0003\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J|\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006!"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "checkIntRange", "allAnnotations", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "FloatRangeConstraint", "IntRangeConstraint", "whisperLint"})
public final class WhisperRangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final String INT_RANGE_ANNOTATION = "com.yy.mobile.whisper.IntRange";
    private static final String FLOAT_RANGE_ANNOTATION = "com.yy.mobile.whisper.FloatRange";
    @JvmField
    @NotNull
    public static final Issue RANGE;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{INT_RANGE_ANNOTATION, FLOAT_RANGE_ANNOTATION});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)INT_RANGE_ANNOTATION)) {
            this.checkIntRange(context, annotation, usage, annotations);
        } else if (Intrinsics.areEqual((Object)qualifiedName, (Object)FLOAT_RANGE_ANNOTATION)) {
            this.checkFloatRange(context, annotation, usage);
        }
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, List<? extends UAnnotation> allAnnotations) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkIntRange(context, annotation, (UElement)uExpression, allAnnotations);
            }
            return;
        }
        String message = Companion.getIntRangeError(context, annotation, argument);
        if (message != null) {
            this.report(context, RANGE, argument, context.getLocation(argument), message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkFloatRange(context, annotation, (UElement)uExpression);
            }
            return;
        }
        FloatRangeConstraint constraint = FloatRangeConstraint.Companion.create(annotation);
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(constant instanceof Number)) {
            PsiElement resolved;
            if (constant instanceof float[] || constant instanceof double[] || constant instanceof int[] || constant instanceof long[]) {
                int message2;
                if (constant instanceof float[]) {
                    for (float value : (float[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message2 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        return;
                    }
                }
                if (constant instanceof double[]) {
                    void var8_8;
                    double[] dArray = (double[])constant;
                    message2 = dArray.length;
                    boolean bl = false;
                    while (var8_8 < message2) {
                        double value = dArray[var8_8];
                        if (!constraint.isValid(value)) {
                            String message3 = constraint.describe(value);
                            this.report(context, RANGE, argument, context.getLocation(argument), message3);
                            return;
                        }
                        ++var8_8;
                    }
                }
                if (constant instanceof int[]) {
                    for (int value : (int[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message4 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message4);
                        return;
                    }
                }
                if (constant instanceof long[]) {
                    void var8_12;
                    long[] lArray = (long[])constant;
                    message2 = lArray.length;
                    boolean bl = false;
                    while (var8_12 < message2) {
                        long value = lArray[var8_12];
                        if (!constraint.isValid(value)) {
                            String message5 = constraint.describe(value);
                            this.report(context, RANGE, argument, context.getLocation(argument), message5);
                            return;
                        }
                        ++var8_12;
                    }
                }
            }
            if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                Boolean contains;
                RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)((PsiModifierListOwner)resolved), (JavaEvaluator)context.getEvaluator());
                RangeConstraint rangeConstraint = RangeConstraint.create((UAnnotation)annotation);
                if (rangeConstraint != null && referenceConstraint != null && (contains = rangeConstraint.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                    String message = rangeConstraint.toString();
                    this.report(context, RANGE, argument, context.getLocation(argument), message);
                }
            }
            return;
        }
        double value = ((Number)constant).doubleValue();
        if (!constraint.isValid(value)) {
            UElement uElement = argument;
            if (!(uElement instanceof UExpression)) {
                uElement = null;
            }
            String string = constraint.describe((UExpression)uElement, value);
            this.report(context, RANGE, argument, context.getLocation(argument), string);
        }
    }

    static {
        Companion = new Companion(null);
        RANGE = Issue.Companion.create("WhisperRange", "Outside Range", "\n                Some parameters are required to in a particular numerical range; this check \\\n                makes sure that arguments passed fall within the range. For arrays, Strings \\\n                and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(WhisperRangeDetector.class, Scope.JAVA_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J%\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector$FloatRangeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "from", "", "to", "fromInclusive", "", "toInclusive", "(DDZZ)V", "getFrom", "()D", "getFromInclusive", "()Z", "getTo", "getToInclusive", "contains", "other", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "describe", "", "argument", "Lorg/jetbrains/uast/UExpression;", "actualValue", "(Lorg/jetbrains/uast/UExpression;Ljava/lang/Double;)Ljava/lang/String;", "isValid", "value", "toString", "Companion", "whisperLint"})
    public static final class FloatRangeConstraint
    extends RangeConstraint {
        private final double from;
        private final double to;
        private final boolean fromInclusive;
        private final boolean toInclusive;
        public static final Companion Companion = new Companion(null);

        public final boolean isValid(double value) {
            return (this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to);
        }

        @NotNull
        public final String describe(double argument) {
            return this.describe(null, argument);
        }

        @JvmOverloads
        @NotNull
        public final String describe(@Nullable UExpression argument, @Nullable Double actualValue) {
            boolean bl;
            int n;
            int n2;
            StringBuilder sb = new StringBuilder(20);
            String valueString = null;
            if (argument instanceof ULiteralExpression) {
                String str = argument.asSourceString();
                if (StringsKt.endsWith$default((String)str, (String)"f", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)str, (String)"F", (boolean)false, (int)2, null)) {
                    String string = str;
                    n2 = 0;
                    n = str.length() - 1;
                    bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n2, n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    str = string3;
                }
                valueString = str;
            } else if (actualValue != null) {
                valueString = String.valueOf(actualValue);
            }
            if (actualValue != null && !this.isValid(actualValue)) {
                double value = actualValue;
                if (this.from != DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY()) {
                    if (this.to != DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY()) {
                        if (this.fromInclusive && value < this.from || !this.fromInclusive && value <= this.from) {
                            sb.append("Value must be ");
                            if (this.fromInclusive) {
                                sb.append('\u2265');
                            } else {
                                sb.append('>');
                            }
                            sb.append(' ');
                            sb.append(String.valueOf(this.from));
                        } else {
                            n2 = this.toInclusive && value > this.to || !this.toInclusive && value >= this.to ? 1 : 0;
                            n = 0;
                            bl = false;
                            if (_Assertions.ENABLED && n2 == 0) {
                                boolean bl2 = false;
                                String string = "Assertion failed";
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            sb.append("Value must be ");
                            if (this.toInclusive) {
                                sb.append('\u2264');
                            } else {
                                sb.append('<');
                            }
                            sb.append(' ');
                            sb.append(String.valueOf(this.to));
                        }
                    } else {
                        sb.append("Value must be ");
                        if (this.fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(String.valueOf(this.from));
                    }
                } else if (this.to != DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY()) {
                    sb.append("Value must be ");
                    if (this.toInclusive) {
                        sb.append('\u2264');
                    } else {
                        sb.append('<');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.to));
                }
                sb.append(" (was ").append(valueString).append(")");
                String string = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                return string;
            }
            if (this.from != DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY()) {
                if (this.to != DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY()) {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.from));
                    sb.append(" and ");
                    if (this.toInclusive) {
                        sb.append('\u2264');
                    } else {
                        sb.append('<');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.to));
                } else {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(this.from));
                }
            } else if (this.to != DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY()) {
                sb.append("Value must be ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(String.valueOf(this.to));
            }
            if (valueString != null) {
                sb.append(" (is ").append(valueString).append(')');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        public static /* synthetic */ String describe$default(FloatRangeConstraint floatRangeConstraint, UExpression uExpression, Double d, int n, Object object) {
            if ((n & 1) != 0) {
                uExpression = null;
            }
            if ((n & 2) != 0) {
                d = null;
            }
            return floatRangeConstraint.describe(uExpression, d);
        }

        @JvmOverloads
        @NotNull
        public final String describe(@Nullable UExpression argument) {
            return FloatRangeConstraint.describe$default(this, argument, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final String describe() {
            return FloatRangeConstraint.describe$default(this, null, null, 3, null);
        }

        @Nullable
        public Boolean contains(@NotNull RangeConstraint other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (other instanceof FloatRangeConstraint) {
                return !(((FloatRangeConstraint)other).from < this.from || ((FloatRangeConstraint)other).to > this.to || !this.fromInclusive && ((FloatRangeConstraint)other).fromInclusive && ((FloatRangeConstraint)other).from == this.from || !this.toInclusive && ((FloatRangeConstraint)other).toInclusive && ((FloatRangeConstraint)other).to == this.to);
            }
            if (other instanceof IntRangeConstraint) {
                return !((double)((IntRangeConstraint)other).getFrom() < this.from || (double)((IntRangeConstraint)other).getTo() > this.to || !this.fromInclusive && (double)((IntRangeConstraint)other).getFrom() == this.from || !this.toInclusive && (double)((IntRangeConstraint)other).getTo() == this.to);
            }
            return null;
        }

        @NotNull
        public String toString() {
            return this.describe(null, null);
        }

        public final double getFrom() {
            return this.from;
        }

        public final double getTo() {
            return this.to;
        }

        public final boolean getFromInclusive() {
            return this.fromInclusive;
        }

        public final boolean getToInclusive() {
            return this.toInclusive;
        }

        @VisibleForTesting
        public FloatRangeConstraint(double from, double to, boolean fromInclusive, boolean toInclusive) {
            this.from = from;
            this.to = to;
            this.fromInclusive = fromInclusive;
            this.toInclusive = toInclusive;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector$FloatRangeConstraint$Companion;", "", "()V", "create", "Lcom/yy/mobile/whisperlint/WhisperRangeDetector$FloatRangeConstraint;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "whisperLint"})
        public static final class Companion {
            @NotNull
            public final FloatRangeConstraint create(@NotNull UAnnotation annotation) {
                Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
                double from = AnnotationCompat.getAnnotationDoubleValue(annotation, "from", FloatCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
                double to = AnnotationCompat.getAnnotationDoubleValue(annotation, "to", FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
                boolean fromInclusive = AnnotationCompat.getAnnotationBooleanValue(annotation, "fromInclusive", true);
                boolean toInclusive = AnnotationCompat.getAnnotationBooleanValue(annotation, "toInclusive", true);
                return new FloatRangeConstraint(from, to, fromInclusive, toInclusive);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector$IntRangeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "from", "", "to", "(JJ)V", "getFrom", "()J", "getTo", "contains", "", "other", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "desc", "", "actualValue", "(Ljava/lang/Long;)Ljava/lang/String;", "describe", "argument", "isValid", "value", "toString", "Companion", "whisperLint"})
    public static final class IntRangeConstraint
    extends RangeConstraint {
        private final long from;
        private final long to;
        public static final Companion Companion = new Companion(null);

        public final boolean isValid(long value) {
            long l = value;
            return this.from <= l && this.to >= l;
        }

        @NotNull
        public final String describe() {
            return this.desc(null);
        }

        @NotNull
        public final String describe(long argument) {
            return this.desc(argument);
        }

        private final String desc(Long actualValue) {
            StringBuilder sb = new StringBuilder(20);
            if (actualValue != null && !this.isValid(actualValue)) {
                long value = actualValue;
                if (value < this.from) {
                    sb.append("Value must be \u2265 ");
                    sb.append(String.valueOf(this.from));
                } else {
                    boolean bl = value > this.to;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    sb.append("Value must be \u2264 ");
                    sb.append(String.valueOf(this.to));
                }
                sb.append(" (was ").append(value).append(')');
                String string = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                return string;
            }
            if (this.to == Long.MAX_VALUE) {
                sb.append("Value must be \u2265 ");
                sb.append(String.valueOf(this.from));
            } else if (this.from == Long.MIN_VALUE) {
                sb.append("Value must be \u2264 ");
                sb.append(String.valueOf(this.to));
            } else {
                sb.append("Value must be \u2265 ");
                sb.append(String.valueOf(this.from));
                sb.append(" and \u2264 ");
                sb.append(String.valueOf(this.to));
            }
            if (actualValue != null) {
                sb.append(" (is ").append(actualValue).append(')');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @NotNull
        public String toString() {
            return this.desc(null);
        }

        @Nullable
        public Boolean contains(@NotNull RangeConstraint other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (other instanceof IntRangeConstraint) {
                return ((IntRangeConstraint)other).from >= this.from && ((IntRangeConstraint)other).to <= this.to;
            }
            if (other instanceof FloatRangeConstraint) {
                if (!((FloatRangeConstraint)other).getFromInclusive() && ((FloatRangeConstraint)other).getFrom() == (double)this.from || !((FloatRangeConstraint)other).getToInclusive() && ((FloatRangeConstraint)other).getTo() == (double)this.to) {
                    return false;
                }
                if (((FloatRangeConstraint)other).getTo() > (double)this.to && (!Double.isInfinite(((FloatRangeConstraint)other).getTo()) || this.to != Long.MAX_VALUE)) {
                    return false;
                }
                return !(((FloatRangeConstraint)other).getFrom() < (double)this.from) || Double.isInfinite(((FloatRangeConstraint)other).getFrom()) && this.from == Long.MIN_VALUE;
            }
            return null;
        }

        public final long getFrom() {
            return this.from;
        }

        public final long getTo() {
            return this.to;
        }

        private IntRangeConstraint(long from, long to) {
            this.from = from;
            this.to = to;
        }

        public /* synthetic */ IntRangeConstraint(long from, long to, DefaultConstructorMarker $constructor_marker) {
            this(from, to);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector$IntRangeConstraint$Companion;", "", "()V", "create", "Lcom/yy/mobile/whisperlint/WhisperRangeDetector$IntRangeConstraint;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "whisperLint"})
        public static final class Companion {
            @NotNull
            public final IntRangeConstraint create(@NotNull UAnnotation annotation) {
                Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
                long from = AnnotationCompat.getAnnotationLongValue(annotation, "from", Integer.MIN_VALUE);
                long to = AnnotationCompat.getAnnotationLongValue(annotation, "to", Integer.MAX_VALUE);
                return new IntRangeConstraint(from, to, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/yy/mobile/whisperlint/WhisperRangeDetector$Companion;", "", "()V", "FLOAT_RANGE_ANNOTATION", "", "INT_RANGE_ANNOTATION", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "getIntRangeError", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "getIssue", "", "()[Lcom/android/tools/lint/detector/api/Issue;", "whisperLint"})
    public static final class Companion {
        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression expression : newExpression.getValueArguments()) {
                    String error = this.getIntRangeError(context, annotation, (UElement)expression);
                    if (error == null) continue;
                    return error;
                }
            }
            IntRangeConstraint constraint = IntRangeConstraint.Companion.create(annotation);
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                PsiElement resolved;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        for (int value : (int[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                    if (o instanceof long[]) {
                        for (long value : (long[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                    Boolean contains;
                    RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)((PsiModifierListOwner)resolved), (JavaEvaluator)context.getEvaluator());
                    RangeConstraint here = RangeConstraint.create((UAnnotation)annotation);
                    if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                        return here.toString();
                    }
                }
                return null;
            }
            long value = ((Number)o).longValue();
            return !constraint.isValid(value) ? constraint.describe(value) : null;
        }

        @NotNull
        public final Issue[] getIssue() {
            return new Issue[]{RANGE};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

