/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.whisperlint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.yy.mobile.whisperlint.support.api2.AnnotationUsageTypeCompat;
import com.yy.mobile.whisperlint.support.api2.PsiJvmConversionHelperCompatKt;
import com.yy.mobile.whisperlint.support.api6.AnnotationCompat;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002Jr\u0010\u0019\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005H\u0016\u00a8\u0006 "}, d2={"Lcom/yy/mobile/whisperlint/WhisperHideDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "applicableAnnotations", "", "", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "reportAnnotationCall", "", "usage", "method", "Lcom/intellij/psi/PsiMethod;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "visitAnnotationUsage", "qualifiedName", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "whisperLint"})
public final class WhisperHideDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    private static final Issue ISSUE_WHISPER_HIDE;
    private static final String hideAnnotation = "com.yy.mobile.whisper.Hide";
    public static final Companion Companion;

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return AnnotationUsageTypeCompat.Companion.setOf(AnnotationUsageTypeCompat.METHOD_CALL, AnnotationUsageTypeCompat.ASSIGNMENT, AnnotationUsageTypeCompat.BINARY, AnnotationUsageTypeCompat.EQUALITY, AnnotationUsageTypeCompat.FIELD_REFERENCE, AnnotationUsageTypeCompat.VARIABLE_REFERENCE).contains(type);
    }

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)hideAnnotation);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        this.reportAnnotationCall(context, usage, method, annotation);
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UQualifiedReferenceExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ WhisperHideDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                UExpression uExpression = node.getSelector();
                if (!(uExpression instanceof KotlinUSimpleReferenceExpression)) {
                    uExpression = null;
                }
                KotlinUSimpleReferenceExpression kotlinUSimpleReferenceExpression = (KotlinUSimpleReferenceExpression)uExpression;
                if (kotlinUSimpleReferenceExpression == null) {
                    return;
                }
                KotlinUSimpleReferenceExpression kotlinGetterOrSetter = kotlinUSimpleReferenceExpression;
                PsiElement psiElement = kotlinGetterOrSetter.resolve();
                if (!(psiElement instanceof PsiMethod)) {
                    psiElement = null;
                }
                PsiMethod psiMethod = (PsiMethod)psiElement;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod psiMethod2 = psiMethod;
                PsiAnnotation psiAnnotation = PsiJvmConversionHelperCompatKt.getAnnotationCompat((PsiModifierListOwner)psiMethod2, "com.yy.mobile.whisper.Hide");
                if (psiAnnotation == null || (psiAnnotation = (UAnnotation)UastContextKt.getUastParentOfType$default((PsiElement)((PsiElement)psiAnnotation), UAnnotation.class, (boolean)false, (int)2, null)) == null) {
                    return;
                }
                PsiAnnotation annotation = psiAnnotation;
                WhisperHideDetector.access$reportAnnotationCall(this.this$0, this.$context, (UElement)node, psiMethod2, (UAnnotation)annotation);
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final void reportAnnotationCall(JavaContext context, UElement usage, PsiMethod method, UAnnotation annotation) {
        String selfClassName;
        Object object = AnnotationCompat.getAnnotationStringValues(annotation, "friend");
        if (object == null || (object = ArraysKt.toMutableSet((Object[])object)) == null) {
            return;
        }
        Object friendClsSet = object;
        PsiMethod psiMethod = method;
        String string = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : (selfClassName = null);
        if (selfClassName != null) {
            friendClsSet.add(selfClassName);
        }
        boolean shouldReport = true;
        UClass outerCls = UastUtils.getContainingUClass((UElement)usage);
        while (outerCls != null) {
            String quaName = outerCls.getQualifiedName();
            String simpleName = outerCls.getName();
            if (CollectionsKt.contains((Iterable)((Iterable)friendClsSet), (Object)quaName) || CollectionsKt.contains((Iterable)((Iterable)friendClsSet), (Object)simpleName)) {
                shouldReport = false;
                break;
            }
            if (outerCls.isStatic()) break;
            outerCls = UastUtils.getContainingUClass((UElement)((UElement)outerCls));
        }
        if (shouldReport) {
            String msg = "Methods that can only be accessed in " + friendClsSet;
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE_WHISPER_HIDE, (UElement)usage, (Location)context.getNameLocation(usage), (String)msg, null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        ISSUE_WHISPER_HIDE = Issue.Companion.create("HideMember", "Methods/Fields that can only be accessed in specified classes.", "This method/field is partially visible. And can only be accessed in the class, which is declared as 'friend' with annotation @Hide.", Category.A11Y, 9, Severity.ERROR, new Implementation(WhisperHideDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    }

    public static final /* synthetic */ void access$reportAnnotationCall(WhisperHideDetector $this, JavaContext context, UElement usage, PsiMethod method, UAnnotation annotation) {
        $this.reportAnnotationCall(context, usage, method, annotation);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yy/mobile/whisperlint/WhisperHideDetector$Companion;", "", "()V", "ISSUE_WHISPER_HIDE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_WHISPER_HIDE", "()Lcom/android/tools/lint/detector/api/Issue;", "hideAnnotation", "", "getIssue", "", "()[Lcom/android/tools/lint/detector/api/Issue;", "whisperLint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_WHISPER_HIDE() {
            return ISSUE_WHISPER_HIDE;
        }

        @NotNull
        public final Issue[] getIssue() {
            return new Issue[]{this.getISSUE_WHISPER_HIDE()};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

