/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.whisperlint;

import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMethod;
import com.yy.mobile.whisperlint.support.api2.AnnotationUsageTypeCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IllegalFormatException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Jr\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/yy/mobile/whisperlint/WhisperDeprecatedDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "usage", "Lorg/jetbrains/uast/UElement;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "whisperLint"})
public final class WhisperDeprecatedDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    private static final Issue ISSUE_WHISPER_DEPRECATED_WARNING;
    @NotNull
    private static final Issue ISSUE_WHISPER_DEPRECATED_ERROR;
    private static final String deprecatedAnnotation = "com.yy.mobile.whisper.DeprecatedBy";
    public static final Companion Companion;

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return AnnotationUsageTypeCompat.Companion.setOf(AnnotationUsageTypeCompat.METHOD_CALL).contains(type);
    }

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)deprecatedAnnotation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        v0 = usage;
        if (!(v0 instanceof UCallExpression)) {
            v0 = null;
        }
        v1 = (UCallExpression)v0;
        if (v1 == null) {
            return;
        }
        methodCall = v1;
        $this$map$iv = methodCall.getValueArguments();
        $i$f$map = false;
        var15_15 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var20_21 = (UExpression)item$iv$iv;
            var24_25 = destination$iv$iv;
            $i$a$-map-WhisperDeprecatedDetector$visitAnnotationUsage$arguments$1 = false;
            var25_26 = it /* !! */ .asSourceString();
            var24_25.add(var25_26);
        }
        $this$toTypedArray$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        v2 = thisCollection$iv.toArray(new String[0]);
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        arguments = v2;
        v3 = annotation.findAttributeValue("receiver");
        receiver = v3 != null ? UastUtils.evaluateString((UExpression)v3) : null;
        v4 /* !! */  = annotation.findAttributeValue("replaceWith");
        if (v4 /* !! */  == null || (v4 /* !! */  = UastUtils.evaluateString((UExpression)v4 /* !! */ )) == null) {
            return;
        }
        replace /* !! */  = v4 /* !! */ ;
        v5 = annotation.findAttributeValue("message");
        message = v5 != null ? UastUtils.evaluateString((UExpression)v5) : null;
        v6 = annotation.findAttributeValue("level");
        level = v6 != null ? v6.asSourceString() : null;
        v7 = issue = level == null || StringsKt.contains$default((CharSequence)level, (CharSequence)"Warning", (boolean)false, (int)2, null) != false ? WhisperDeprecatedDetector.ISSUE_WHISPER_DEPRECATED_WARNING : WhisperDeprecatedDetector.ISSUE_WHISPER_DEPRECATED_ERROR;
        if (receiver == null || StringsKt.isBlank((CharSequence)receiver)) {
            receiverSrc = methodCall.getReceiver();
            if (receiverSrc != null) {
                if (receiverSrc instanceof KotlinUFunctionCallExpression && Intrinsics.areEqual((Object)((KotlinUFunctionCallExpression)receiverSrc).getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    v8 = receiverSrc.asSourceString();
                    v9 = ((KotlinUFunctionCallExpression)receiverSrc).getClassReference().getResolvedName();
                    if (v9 == null) {
                        v9 = "";
                    }
                    v10 = StringsKt.replace$default((String)v8, (String)"<init>", (String)v9, (boolean)false, (int)4, null);
                } else {
                    v10 = receiverSrc.asSourceString();
                }
            } else {
                v10 = "";
            }
        } else {
            v10 = receiver;
        }
        methodReceiver = v10;
        try {
            it /* !! */  = replace /* !! */ ;
            $i$a$-map-WhisperDeprecatedDetector$visitAnnotationUsage$arguments$1 = Arrays.copyOf(arguments, arguments.length);
            var22_28 = false;
            v11 = String.format((String)it /* !! */ , Arrays.copyOf($i$a$-map-WhisperDeprecatedDetector$visitAnnotationUsage$arguments$1, $i$a$-map-WhisperDeprecatedDetector$visitAnnotationUsage$arguments$1.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"java.lang.String.format(this, *args)");
            it /* !! */  = v11;
        }
        catch (IllegalFormatException e) {
            it /* !! */  = replace /* !! */ ;
        }
        methodSelector /* !! */  = it /* !! */ ;
        v12 /* !! */  = code /* !! */  = StringsKt.isBlank((CharSequence)methodReceiver) != false ? methodSelector /* !! */  : methodReceiver + '.' + (String)methodSelector /* !! */ ;
        if (message == null) ** GOTO lbl-1000
        var22_29 = message;
        var23_31 = false;
        if (var22_29.length() == 0) lbl-1000:
        // 2 sources

        {
            v13 = "Use " + (String)code /* !! */  + " instead of this method.";
        } else {
            v13 = message;
        }
        hint = v13;
        fix = LintFix.create().replace().name("replace with " + (String)code /* !! */ ).with((String)code /* !! */ ).reformat(true).shortenNames().build();
        context.report(issue, usage, context.getLocation(usage), hint, fix);
    }

    static {
        Companion = new Companion(null);
        ISSUE_WHISPER_DEPRECATED_WARNING = Issue.Companion.create("DeprecatedWarning", "deprecated methods", "The methods are outdated. Please replace them with the new ones.", Category.USABILITY, 5, Severity.WARNING, new Implementation(WhisperDeprecatedDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_DEPRECATED_ERROR = Issue.Companion.create("DeprecatedError", "deprecated methods", "The methods are outdated. Please replace them with the new ones.", Category.USABILITY, 5, Severity.ERROR, new Implementation(WhisperDeprecatedDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/yy/mobile/whisperlint/WhisperDeprecatedDetector$Companion;", "", "()V", "ISSUE_WHISPER_DEPRECATED_ERROR", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_WHISPER_DEPRECATED_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WHISPER_DEPRECATED_WARNING", "getISSUE_WHISPER_DEPRECATED_WARNING", "deprecatedAnnotation", "", "getIssue", "", "()[Lcom/android/tools/lint/detector/api/Issue;", "whisperLint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_WHISPER_DEPRECATED_WARNING() {
            return ISSUE_WHISPER_DEPRECATED_WARNING;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_DEPRECATED_ERROR() {
            return ISSUE_WHISPER_DEPRECATED_ERROR;
        }

        @NotNull
        public final Issue[] getIssue() {
            return new Issue[]{this.getISSUE_WHISPER_DEPRECATED_WARNING(), this.getISSUE_WHISPER_DEPRECATED_ERROR()};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

