/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.logging;

import android.os.SystemClock;
import android.util.Log;
import com.yy.androidlib.util.logging.FastDateFormat;
import com.yy.androidlib.util.logging.YYAppender;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class LogToES {
    private static final String BAK_EXT = ".bak";
    private static final FastDateFormat LOG_FORMAT = FastDateFormat.getInstance("yyyy:MM:dd kk:mm:ss");
    private static FastDateFormat simpleDateFormat = FastDateFormat.getInstance("-MM-dd-kk-mm-ss");
    private static final long DAY_DELAY = 864000000L;
    public static final int MAX_FILE_SIZE = 2;
    public static final int DEFAULT_BAK_FILE_NUM_LIMIT = 2;
    private static int mBackFileNumLimit = 2;
    public static final int DEFAULT_BUFF_SIZE = 32768;
    private static int mBuffSize = 32768;
    private static final Object mLock = new Object();
    private static BufferedWriter mWriter;
    private static String mPath;
    private static long mLastMillis;
    private static final long FLUSH_INTERVAL = 5000L;
    private static volatile String mLogPath;

    public static void setBackupLogLimitInMB(int logCapacityInMB) {
        mBackFileNumLimit = (logCapacityInMB + 2 - 1) / 2;
    }

    public static boolean setLogPath(String logDir) {
        if (logDir == null || logDir.length() == 0) {
            return false;
        }
        mLogPath = logDir;
        new File(logDir).mkdirs();
        return new File(logDir).isDirectory();
    }

    public static String getLogPath() {
        return mLogPath;
    }

    public static void setBuffSize(int bytes) {
        mBuffSize = bytes;
    }

    public static void writeLogToFile(String dir, String fileName, String msg, boolean immediateClose, long timeMillis) throws IOException {
        LogToES.writeLog(dir, fileName, msg, immediateClose, timeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(String path, String fileName, String msg, boolean immediateClose, long timeMillis) throws IOException {
        File dirFile = new File(path);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        boolean needCreate = false;
        File logFile = LogToES.createFile(path, fileName);
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else {
            long fileSize = logFile.length() >>> 20;
            if (fileSize > 2L) {
                LogToES.deleteOldLogs();
                String fileExt = simpleDateFormat.format(timeMillis);
                StringBuilder sb = new StringBuilder(path);
                sb.append(File.separator).append(fileName).append(fileExt).append(BAK_EXT);
                LogToES.close();
                File fileNameTo = new File(sb.toString());
                logFile.renameTo(fileNameTo);
                logFile = LogToES.createFile(path, fileName);
                needCreate = true;
                LogToES.limitVolume();
            }
        }
        String strLog = LOG_FORMAT.format(timeMillis);
        StringBuilder sb = new StringBuilder(strLog);
        sb.append(' ');
        sb.append(msg);
        sb.append('\n');
        strLog = sb.toString();
        Object object = mLock;
        synchronized (object) {
            if (mPath == null) {
                mPath = logFile.getAbsolutePath();
                needCreate = true;
            } else if (!LogToES.equal(mPath, logFile.getAbsolutePath())) {
                BufferedWriter writer = mWriter;
                if (writer != null) {
                    writer.close();
                }
                mWriter = null;
                mPath = null;
                needCreate = true;
            }
            BufferedWriter bufWriter = mWriter;
            if (needCreate || bufWriter == null) {
                mPath = logFile.getAbsolutePath();
                FileWriter fileWriter = new FileWriter(logFile, true);
                mWriter = bufWriter = new BufferedWriter(fileWriter, mBuffSize);
            }
            bufWriter.write(strLog);
            long curMillis = SystemClock.elapsedRealtime();
            if (curMillis - mLastMillis >= 5000L) {
                bufWriter.flush();
                mLastMillis = curMillis;
            }
            if (immediateClose) {
                bufWriter.close();
                mPath = null;
                mWriter = null;
            }
        }
    }

    private static File createFile(String path, String fileName) {
        return new File(path.endsWith(File.separator) ? path + fileName : path + File.separator + fileName);
    }

    private static boolean equal(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    private static void deleteOldLogs() {
        String dir = LogToES.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        long now = System.currentTimeMillis();
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            long lastModifiedTime;
            if (!LogToES.isBakFile(file.getName()) || now - (lastModifiedTime = file.lastModified()) <= 864000000L) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getLogOutputPaths(YYAppender.LogOutputPaths out, String currentName) {
        String dir = LogToES.getLogPath();
        if (dir == null || currentName == null) {
            return false;
        }
        out.dir = dir;
        String current = null;
        Object object = mLock;
        synchronized (object) {
            current = mPath;
        }
        if (current == null) {
            current = LogToES.createFile(dir, currentName).getAbsolutePath();
        }
        out.currentLogFile = current;
        File folder = new File(dir);
        File[] files = folder.listFiles();
        if (files != null) {
            long maxModifiedTime = 0L;
            String dest = null;
            for (File e : files) {
                if (!LogToES.isBakFile(e.getAbsolutePath()) || e.lastModified() <= maxModifiedTime) continue;
                maxModifiedTime = e.lastModified();
                dest = e.getAbsolutePath();
            }
            out.latestBackupFile = dest;
        }
        return true;
    }

    private static boolean isBakFile(String file) {
        return file.endsWith(BAK_EXT);
    }

    private static void limitVolume() {
        String dir = LogToES.getLogPath();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        File[] files = dirFile.listFiles();
        if (files == null || files.length <= Math.max(0, mBackFileNumLimit)) {
            return;
        }
        int numOfDeletable = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            File file = files[i];
            if (!LogToES.isBakFile(file.getName())) continue;
            ++numOfDeletable;
        }
        if (numOfDeletable <= 0) {
            return;
        }
        File[] deletables = new File[numOfDeletable];
        int i = 0;
        for (File e : files) {
            if (i >= numOfDeletable) break;
            if (!LogToES.isBakFile(e.getName())) continue;
            deletables[i++] = e;
        }
        LogToES.deleteIfOutOfBound(deletables);
    }

    private static void deleteIfOutOfBound(File[] files) {
        if (files.length <= mBackFileNumLimit) {
            return;
        }
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return rhs.getName().compareTo(lhs.getName());
            }
        };
        Arrays.sort(files, comparator);
        int filesNum = files.length;
        for (int i = mBackFileNumLimit; i < filesNum; ++i) {
            File file = files[i];
            if (file.delete()) continue;
            Log.e((String)"LogToES", (String)("LogToES failed to delete file " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Object object = mLock;
        synchronized (object) {
            BufferedWriter writer = mWriter;
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = mLock;
        synchronized (object) {
            BufferedWriter writer = mWriter;
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            mPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpen() {
        Object object = mLock;
        synchronized (object) {
            BufferedWriter writer = mWriter;
            return writer != null;
        }
    }

    static {
        mLastMillis = 0L;
    }
}

