/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.aa;
import com.xiaomi.mipush.sdk.ab;
import com.xiaomi.mipush.sdk.ak;
import com.xiaomi.mipush.sdk.ap;
import com.xiaomi.mipush.sdk.aq;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.e;
import com.xiaomi.mipush.sdk.h;
import com.xiaomi.mipush.sdk.q;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.t;
import com.xiaomi.push.ai;
import com.xiaomi.push.ax;
import com.xiaomi.push.bi;
import com.xiaomi.push.dh;
import com.xiaomi.push.di;
import com.xiaomi.push.ek;
import com.xiaomi.push.el;
import com.xiaomi.push.em;
import com.xiaomi.push.ew;
import com.xiaomi.push.g;
import com.xiaomi.push.hc;
import com.xiaomi.push.hg;
import com.xiaomi.push.hh;
import com.xiaomi.push.hm;
import com.xiaomi.push.hp;
import com.xiaomi.push.hq;
import com.xiaomi.push.hw;
import com.xiaomi.push.i;
import com.xiaomi.push.ib;
import com.xiaomi.push.ic;
import com.xiaomi.push.ig;
import com.xiaomi.push.ii;
import com.xiaomi.push.ik;
import com.xiaomi.push.l;
import com.xiaomi.push.n;
import com.xiaomi.push.service.an;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static Context sContext;
    private static long sCurMsgId;

    public static boolean shouldUseMIUIPush(Context context) {
        return ak.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, String string3) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), string3, null);
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.registerPush(context, string, string2, pushConfiguration, null, null);
    }

    private static void registerPush(Context context, final String string, final String string2, PushConfiguration pushConfiguration, final String string3, final ICallbackResult iCallbackResult) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        com.xiaomi.push.t.a(context);
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        e.a(sContext).a(pushConfiguration);
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                MiPushClient.initialize(sContext, string, string2, null, string3, iCallbackResult);
            }
        });
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            context2.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback, null, null);
    }

    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback, String string3, ICallbackResult iCallbackResult) {
        try {
            boolean bl2;
            com.xiaomi.channel.commonutils.logger.b.a(context.getApplicationContext());
            com.xiaomi.channel.commonutils.logger.b.e("sdk_version = 3_7_9");
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (iCallbackResult != null) {
                PushMessageHandler.a(iCallbackResult);
            }
            if (com.xiaomi.push.t.a(sContext)) {
                t.a(sContext);
            }
            boolean bl3 = bl2 = b.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                ak.a(sContext).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && b.a(sContext).a(string, string2) && !b.a(sContext).e()) {
                Object object;
                Object object2;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, b.a(sContext).c());
                } else {
                    object2 = new ArrayList<String>();
                    object2.add(b.a(sContext).c());
                    object = PushMessageHelper.generateCommandMessage(ew.a.a, object2, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object);
                }
                ak.a(sContext).a();
                if (b.a(sContext).a()) {
                    object2 = new ib();
                    ((ib)object2).b(b.a(sContext).a());
                    ((ib)object2).c(hm.g.a);
                    ((ib)object2).a(com.xiaomi.push.service.aq.a());
                    ((ib)object2).a = new HashMap();
                    ((ib)object2).a.put("app_version", g.a(sContext, sContext.getPackageName()));
                    ((ib)object2).a.put("app_version_code", Integer.toString(g.a(sContext, sContext.getPackageName())));
                    ((ib)object2).a.put("push_sdk_vn", "3_7_9");
                    ((ib)object2).a.put("push_sdk_vc", Integer.toString(30709));
                    i.a(sContext, (Map<String, String>)((Object)((ib)object2).a));
                    object = b.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        ((ib)object2).a.put("deviceid", object);
                    }
                    ak.a(sContext).a(object2, hc.i, false, null);
                }
                if (!n.a(sContext, "update_devId", false)) {
                    MiPushClient.updateImeiOrOaid();
                    n.a(sContext, "update_devId", true);
                }
                if (!TextUtils.isEmpty((CharSequence)(object2 = i.c(sContext)))) {
                    object = new hw();
                    ((hw)object).a(com.xiaomi.push.service.aq.a());
                    ((hw)object).b(string);
                    ((hw)object).c(ew.j.a);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string4 = i.b(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        arrayList.add(string4);
                    }
                    arrayList.add((String)(object2 != null ? object2 : ""));
                    arrayList.add(Build.MODEL != null ? Build.MODEL : "");
                    arrayList.add(Build.BOARD != null ? Build.BOARD : "");
                    ((hw)object).a(arrayList);
                    ak.a(sContext).a(object, hc.j, false, null);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object = new ib();
                    ((ib)object).b(b.a(sContext).a());
                    ((ib)object).c(hm.j.a);
                    ((ib)object).a(com.xiaomi.push.service.aq.a());
                    ((ib)object).a(false);
                    ak.a(sContext).a(object, hc.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                int n2;
                String string5;
                String string6 = bi.a(6);
                b.a(sContext).a();
                b.a(sContext).a(Constants.a());
                b.a(sContext).a(string, string2, string6);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                MiPushClient.clearNotification(context);
                ic ic2 = new ic();
                ic2.a(com.xiaomi.push.service.aq.a());
                ic2.b(string);
                ic2.e(string2);
                ic2.d(sContext.getPackageName());
                ic2.f(string6);
                ic2.c(g.a(sContext, sContext.getPackageName()));
                ic2.b(g.a(sContext, sContext.getPackageName()));
                ic2.h("3_7_9");
                ic2.a(30709);
                ic2.a(hq.c);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    ic2.g(string3);
                }
                if (!l.d() && !TextUtils.isEmpty((CharSequence)(string5 = i.g(sContext)))) {
                    ic2.i(bi.a(string5) + "," + i.j(sContext));
                }
                if ((n2 = i.a()) >= 0) {
                    ic2.c(n2);
                }
                ak.a(sContext).a(ic2, bl2);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            aq.a(sContext);
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                if (Logger.getUserLogger() != null) {
                    Logger.setLogger(sContext, Logger.getUserLogger());
                }
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            MiPushClient.operateSyncAction(context);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = an.a(sContext).a(hh.A.a(), 86400);
        ai.a(sContext).a(new aa(sContext), n2, 5);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = hh.z.a();
        if (an.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            dh.a().a(new q(context));
            ai.a(sContext).a(new Runnable(){

                @Override
                public void run() {
                    di.a(sContext);
                }
            }, 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return l.b();
    }

    private static void updateImeiOrOaid() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!l.d() && (i.f(sContext) != null || ax.a(sContext).a())) {
                    ib ib2 = new ib();
                    ib2.b(b.a(sContext).a());
                    ib2.c(hm.g.a);
                    ib2.a(com.xiaomi.push.service.aq.a());
                    ib2.a(new HashMap<String, String>());
                    String string = "";
                    String string2 = i.f(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        string = string + bi.a(string2);
                    }
                    String string3 = i.h(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string3)) {
                        string = string + "," + string3;
                    }
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ib2.a().put("imei_md5", string);
                    }
                    ax.a(sContext).a(ib2.a());
                    i.a(sContext, (Map<String, String>)((Object)ib2.a));
                    int n2 = i.a();
                    if (n2 >= 0) {
                        ib2.a().put("space_id", Integer.toString(n2));
                    }
                    ak.a(sContext).a(ib2, hc.i, false, null);
                }
            }
        }).start();
    }

    public static void awakeApps(final Context context, final String[] stringArray) {
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String string : stringArray) {
                        PackageInfo packageInfo;
                        if (TextUtils.isEmpty((CharSequence)string) || (packageInfo = context.getPackageManager().getPackageInfo(string, 4)) == null) continue;
                        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a(throwable);
                }
            }
        });
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, hq hq2) {
        if (!b.a(context).c()) {
            return;
        }
        String string = bi.a(6);
        String string2 = b.a(context).a();
        String string3 = b.a(context).b();
        b.a(context).a();
        MiPushClient.clearNotification(context);
        b.a(context).a(Constants.a());
        b.a(context).a(string2, string3, string);
        ic ic2 = new ic();
        ic2.a(com.xiaomi.push.service.aq.a());
        ic2.b(string2);
        ic2.e(string3);
        ic2.f(string);
        ic2.d(context.getPackageName());
        ic2.c(g.a(context, context.getPackageName()));
        ic2.a(hq2);
        ak.a(context).a(ic2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        hp hp2 = new hp();
        hp2.a(miPushMessage.getMessageId());
        hp2.b(miPushMessage.getTopic());
        hp2.d(miPushMessage.getDescription());
        hp2.c(miPushMessage.getTitle());
        hp2.c(miPushMessage.getNotifyId());
        hp2.a(miPushMessage.getNotifyType());
        hp2.b(miPushMessage.getPassThrough());
        hp2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), hp2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, hp hp2, String string2) {
        ib ib2 = new ib();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!b.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            ib2.b(b.a(context).a());
        } else {
            ib2.b(string2);
        }
        ib2.c("bar:click");
        ib2.a(string);
        ib2.a(false);
        ak.a(context).a(ib2, hc.i, false, hp2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, hp hp2, String string2, String string3) {
        ib ib2 = new ib();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        ib2.b(string3);
        ib2.c("bar:click");
        ib2.a(string);
        ib2.a(false);
        ak.a(context).a(ib2, hc.i, false, true, hp2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        ak.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        ak.a(context).e();
    }

    public static void unregisterPush(Context context) {
        h.c(context);
        an.a(context).a();
        if (!b.a(context).b()) {
            return;
        }
        ii ii2 = new ii();
        ii2.a(com.xiaomi.push.service.aq.a());
        ii2.b(b.a(context).a());
        ii2.c(b.a(context).c());
        ii2.e(b.a(context).b());
        ii2.d(context.getPackageName());
        ak.a(context).a(ii2);
        PushMessageHandler.a();
        PushMessageHandler.b();
        b.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        ak.a(context).a(true);
    }

    public static void enablePush(Context context) {
        ak.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        ak.a(context).a(null, ap.c, d.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        ak.a(context).a(null, ap.d, d.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        ak.a(context).a(null, ap.e, d.c);
    }

    public static void syncAssembleFTOSPushToken(Context context) {
        ak.a(context).a(null, ap.f, d.d);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ew.c.a, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ew.d.a, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ew.e.a, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ew.f.a, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            ig ig2 = new ig();
            String string3 = com.xiaomi.push.service.aq.a();
            ig2.a(string3);
            ig2.b(b.a(context).a());
            ig2.c(string);
            ig2.d(context.getPackageName());
            ig2.e(string2);
            com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ew.g) + ", " + string3);
            ak.a(context).a(ig2, hc.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ew.g.a, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!b.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        ik ik2 = new ik();
        String string3 = com.xiaomi.push.service.aq.a();
        ik2.a(string3);
        ik2.b(b.a(context).a());
        ik2.c(string);
        ik2.d(context.getPackageName());
        ik2.e(string2);
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ew.h) + ", " + string3);
        ak.a(context).a(ik2, hc.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        ak.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        ak.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        ak.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!b.a(context).b()) {
            return;
        }
        hm hm2 = bl2 ? hm.R : hm.Q;
        ib ib2 = new ib();
        ib2.b(b.a(context).a());
        ib2.c(hm2.a);
        ib2.d(context.getPackageName());
        ib2.a(com.xiaomi.push.service.aq.a());
        ib2.a(false);
        ak.a(context).a(ib2, hc.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (b.a(context).c()) {
            return b.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (b.a(context).c()) {
            return b.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (ew.c.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 86400000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ew.c.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ew.d.a.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + bi.a(arrayList.toString(), 3) + " is unseted");
        } else if (ew.e.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ew.e.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ew.f.a.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + bi.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a())) {
            return;
        }
        hw hw2 = new hw();
        String string3 = com.xiaomi.push.service.aq.a();
        hw2.a(string3);
        hw2.b(b.a(context).a());
        hw2.c(string);
        for (String string4 : arrayList) {
            hw2.a(string4);
        }
        hw2.e(string2);
        hw2.d(context.getPackageName());
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + string + ", " + string3);
        ak.a(context).a(hw2, hc.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, ew.i.a, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ew.i.a, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, ew.i.a, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.a);
    }

    protected static boolean getOpenFCMPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.b);
    }

    protected static boolean getOpenOPPOPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.c);
    }

    protected static boolean getOpenVIVOPush(Context context) {
        return e.a(context).b(d.d);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        com.xiaomi.push.r.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        com.xiaomi.push.r.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    private static void initEventPerfLogic(final Context context) {
        em.a(new em.a(){

            @Override
            public void uploader(Context context, hg hg2) {
                MiTinyDataClient.upload(context, hg2);
            }
        });
        Config config = em.a(context);
        com.xiaomi.clientreport.manager.a.a(context).a("3_7_9");
        ClientReportClient.init(context, config, new ek(context), new el(context));
        a.a(context);
        r.a(context, config);
        an.a(context).a(new an.a(100, "perf event job update"){

            @Override
            protected void onCallback() {
                em.a(context);
            }
        });
    }

    @Deprecated
    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    private static void operateSyncAction(Context context) {
        if ("syncing".equals(ab.a(sContext).a(ap.a))) {
            MiPushClient.disablePush(sContext);
        }
        if ("syncing".equals(ab.a(sContext).a(ap.b))) {
            MiPushClient.enablePush(sContext);
        }
        if ("syncing".equals(ab.a(sContext).a(ap.c))) {
            MiPushClient.syncAssemblePushToken(sContext);
        }
        if ("syncing".equals(ab.a(sContext).a(ap.d))) {
            MiPushClient.syncAssembleFCMPushToken(sContext);
        }
        if ("syncing".equals(ab.a(sContext).a(ap.e))) {
            MiPushClient.syncAssembleCOSPushToken(context);
        }
        if ("syncing".equals(ab.a(sContext).a(ap.f))) {
            MiPushClient.syncAssembleFTOSPushToken(context);
        }
    }

    public static void registerToken(Context context, String string, String string2, String string3, UPSRegisterCallBack uPSRegisterCallBack) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), null, uPSRegisterCallBack);
    }

    public static void unRegisterToken(Context context, UPSUnRegisterCallBack uPSUnRegisterCallBack) {
        MiPushClient.unregisterPush(context);
        if (uPSUnRegisterCallBack != null) {
            TokenResult tokenResult = new TokenResult();
            tokenResult.setToken(null);
            tokenResult.getToken();
            tokenResult.setResultCode(0L);
            tokenResult.getResultCode();
            uPSUnRegisterCallBack.onResult(tokenResult);
        }
    }

    public static void turnOnPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.enablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    public static void turnOffPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.disablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    public static class CodeResult {
        private long resultCode = -1L;

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static class TokenResult {
        private String token = null;
        private long resultCode = -1L;

        protected void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static interface UPSTurnCallBack
    extends ICallbackResult<CodeResult> {
    }

    public static interface UPSUnRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface UPSRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface ICallbackResult<R> {
        public void onResult(R var1);
    }

    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

