/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.oppo;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.yx95.push.core.IPushClient;
import com.yx95.push.core.PushCore;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.util.PushLog;

public class OPPOClient
implements IPushClient {
    private static final String OPPO_PUSH_APP_KEY = "PUSH_CORE_OPPO_APP_KEY";
    private static final String OPPO_PUSH_APP_SECRET = "PUSH_CORE_OPPO_APP_SECRET";
    private Context mContext;
    private String mAppKey;
    private String mAppSecret;

    @Override
    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            this.mAppKey = metaData.getString(OPPO_PUSH_APP_KEY).trim();
            this.mAppSecret = metaData.getString(OPPO_PUSH_APP_SECRET).trim();
            HeytapPushManager.init((Context)this.mContext, (boolean)PushCore.DEBUG);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            PushLog.e("can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY on AndroidManifest.xml");
        }
    }

    @Override
    public void bindAlias(String alias) {
    }

    @Override
    public void unBindAlias(String alias) {
    }

    @Override
    public void register() {
        HeytapPushManager.register((Context)this.mContext, (String)this.mAppKey, (String)this.mAppSecret, (ICallBackResultService)new ICallBackResultService(){

            public void onRegister(int responseCode, String registerID) {
                if (responseCode == 0) {
                    PushMessageHandleFactory.commandResult(OPPOClient.this.mContext, 2011, 200, registerID);
                } else {
                    PushMessageHandleFactory.commandResult(OPPOClient.this.mContext, 2012, 400, "registerID");
                }
            }

            public void onUnRegister(int i) {
            }

            public void onSetPushTime(int i, String s) {
            }

            public void onGetPushStatus(int i, int i1) {
            }

            public void onGetNotificationStatus(int i, int i1) {
            }
        });
    }

    @Override
    public void unRegister() {
        HeytapPushManager.unRegister();
    }
}

