/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.mipush;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.yx95.push.core.IPushClient;
import com.yx95.push.util.PushLog;

public class MIPushClient
implements IPushClient {
    public static final String MI_PUSH_APP_ID = "PUSH_CORE_MI_APP_ID";
    public static final String MI_PUSH_APP_KEY = "PUSH_CORE_MI_APP_KEY";
    private Context mContext;
    private String mAppId;
    private String mAppKey;

    @Override
    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            this.mAppId = metaData.getString(MI_PUSH_APP_ID).trim();
            this.mAppKey = metaData.getString(MI_PUSH_APP_KEY).trim();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            PushLog.e("can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY on AndroidManifest.xml");
        }
    }

    @Override
    public void bindAlias(String alias) {
        MiPushClient.setUserAccount((Context)this.mContext, (String)alias, null);
    }

    @Override
    public void unBindAlias(String alias) {
        MiPushClient.setUserAccount((Context)this.mContext, (String)alias, null);
    }

    @Override
    public void register() {
        MiPushClient.registerPush((Context)this.mContext, (String)this.mAppId, (String)this.mAppKey);
    }

    @Override
    public void unRegister() {
        MiPushClient.unregisterPush((Context)this.mContext);
    }
}

