/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.jpush;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.util.PushLog;
import com.yx95.push.util.PushUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JPushReceiver
extends BroadcastReceiver {
    private static final String TAG = JPushReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!"cn.jpush.android.intent.REGISTRATION".equals(intent.getAction())) {
            if ("cn.jpush.android.intent.MESSAGE_RECEIVED".equals(intent.getAction())) {
                PushLog.i("\u63a5\u53d7\u5230\u63a8\u9001\u4e0b\u6765\u7684\u81ea\u5b9a\u4e49\u6d88\u606f(\u900f\u4f20\u6d88\u606f)");
                String message = bundle.getString("cn.jpush.android.TITLE");
                String desc = bundle.getString("cn.jpush.android.TITLE");
                PushMessageHandleFactory.messageReceived(context, message, desc, null);
            } else if ("cn.jpush.android.intent.NOTIFICATION_RECEIVED".equals(intent.getAction())) {
                Map<String, String> extraMap;
                PushLog.i("\u63a5\u53d7\u5230\u63a8\u9001\u4e0b\u6765\u7684\u901a\u77e5");
                String title = bundle.getString("cn.jpush.android.NOTIFICATION_CONTENT_TITLE");
                String content = bundle.getString("cn.jpush.android.ALERT");
                String extra = bundle.getString("cn.jpush.android.EXTRA");
                int notifyId = bundle.getInt("cn.jpush.android.NOTIFICATION_ID");
                try {
                    extraMap = PushUtils.json2Map(new JSONObject(extra));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    extraMap = null;
                }
                PushMessageHandleFactory.notificationMessageReceived(context, notifyId, title, content, extra, extraMap);
            } else if ("cn.jpush.android.intent.NOTIFICATION_OPENED".equals(intent.getAction())) {
                Map<String, String> extraMap;
                Log.d((String)TAG, (String)"\u7528\u6237\u70b9\u51fb\u6253\u5f00\u4e86\u901a\u77e5");
                String title = bundle.getString("cn.jpush.android.NOTIFICATION_CONTENT_TITLE");
                String content = bundle.getString("cn.jpush.android.ALERT");
                String extra = bundle.getString("cn.jpush.android.EXTRA");
                int notifyId = bundle.getInt("cn.jpush.android.NOTIFICATION_ID");
                try {
                    extraMap = PushUtils.json2Map(new JSONObject(extra));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    extraMap = null;
                }
                PushMessageHandleFactory.notificationMessageClicked(context, notifyId, title, content, extra, extraMap);
            } else {
                Log.d((String)TAG, (String)("Unhandled intent - " + intent.getAction()));
            }
        }
    }
}

