/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.core;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import com.yx95.push.entity.PushCommand;
import com.yx95.push.entity.PushMessage;
import java.util.Map;

public class PushMessageHandleFactory {
    private static final String PUSH_DATA = "push_data";
    private static final int NO_NOTIFY_ID = 0;

    public static void notificationMessageClicked(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.NOTIFICATION_CLICKED", new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    public static void notificationMessageReceived(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.NOTIFICATION_MESSAGE_ARRIVED", new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    public static void messageReceived(Context context, String msg, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.MESSAGE_RECEIVED", new PushMessage(0, null, null, msg, desc, keyValue));
    }

    public static void commandResult(Context context, int type, int resultCode, String msg) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.COMMAND_RESULT", new PushCommand(type, resultCode, msg));
    }

    private static void handleMessage(Context context, String action, Parcelable data) {
        Intent intent = new Intent(action);
        intent.putExtra(PUSH_DATA, data);
        intent.addCategory(context.getPackageName());
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }

    public static Parcelable parseParcelable(Intent intent) {
        return intent.getParcelableExtra(PUSH_DATA);
    }
}

