package com.yx95.push.vivo;

import android.content.Context;

import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.yx95.push.core.IPushClient;

/**
 * @Description:
 * @author:45457
 * @date: 2020/9/9
 * @version: V1.0
 */
public class VivoClient implements IPushClient {

  private Context mContext;

  @Override public void init(Context context) {
    mContext = context.getApplicationContext();
    PushClient.getInstance(mContext).initialize();
  }

  @Override public void bindAlias(String alias) {
    PushClient.getInstance(mContext).bindAlias(alias, new IPushActionListener() {
      @Override public void onStateChanged(int i) {

      }
    });
  }

  @Override public void unBindAlias(String alias) {
    PushClient.getInstance(mContext).unBindAlias(alias, new IPushActionListener() {
      @Override public void onStateChanged(int i) {

      }
    });
  }

  @Override public void register() {
    PushClient.getInstance(mContext).turnOnPush(new IPushActionListener() {
      @Override public void onStateChanged(int responseCode) {
        if (responseCode == 0) {

        }
      }
    });
  }

  @Override public void unRegister() {
    PushClient.getInstance(mContext).turnOffPush(new IPushActionListener() {
      @Override public void onStateChanged(int i) {

      }
    });
  }
}
