package com.yx95.push.oppo;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.mode.ErrorCode;
import com.yx95.push.PushConstants;
import com.yx95.push.core.IPushClient;
import com.yx95.push.core.PushCore;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushCommand;
import com.yx95.push.util.PushLog;

/**
 * @Description:
 * @author:45457
 * @date: 2020/9/9
 * @version: V1.0
 */
public class OPPOClient implements IPushClient {

  private static final String OPPO_PUSH_APP_KEY =
      PushConstants.META_DATA_PUSH_PREFIX + "OPPO_APP_KEY";
  private static final String OPPO_PUSH_APP_SECRET =
      PushConstants.META_DATA_PUSH_PREFIX + "OPPO_APP_SECRET";

  private Context mContext;
  private String mAppKey;
  private String mAppSecret;

  @Override public void init(Context context) {
    mContext = context.getApplicationContext();
    try {
      Bundle metaData = context.getPackageManager()
          .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA).metaData;
      mAppKey = metaData.getString(OPPO_PUSH_APP_KEY).trim();
      mAppSecret = metaData.getString(OPPO_PUSH_APP_SECRET).trim();

      HeytapPushManager.init(mContext, PushCore.DEBUG);
    } catch (PackageManager.NameNotFoundException e) {
      e.printStackTrace();
      PushLog.e("can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY on AndroidManifest.xml");
    }
  }

  @Override public void bindAlias(String alias) {
  }

  @Override public void unBindAlias(String alias) {

  }

  @Override public void register() {
    HeytapPushManager.register(mContext, mAppKey, mAppSecret, new ICallBackResultService() {
      @Override public void onRegister(int responseCode, String registerID) {
        if (responseCode == ErrorCode.SUCCESS) {
          PushMessageHandleFactory.commandResult(mContext, PushCommand.TYPE_REGISTER,
              PushCommand.RESULT_OK, registerID);
        } else {
          PushMessageHandleFactory.commandResult(mContext, PushCommand.TYPE_UNREGISTER,
              PushCommand.RESULT_ERROR, "registerID");
        }
      }

      @Override public void onUnRegister(int i) {

      }

      @Override public void onSetPushTime(int i, String s) {

      }

      @Override public void onGetPushStatus(int i, int i1) {

      }

      @Override public void onGetNotificationStatus(int i, int i1) {

      }
    });
  }

  @Override public void unRegister() {
    HeytapPushManager.unRegister();
  }
}
