package com.yx95.push.mipush;

import android.content.Context;

import com.xiaomi.mipush.sdk.ErrorCode;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushCommand;

import java.util.List;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.bxkj.push.XMPush
 * @Description: 小米PushReceiver
 * @TODO: TODO
 * @date 2018/5/25
 */

public class MiPushMessageReceiver extends PushMessageReceiver {

  private String mTopic;
  private String mAlias;

  @Override

  public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
    PushMessageHandleFactory.messageReceived(context, miPushMessage.getContent(),
        miPushMessage.getDescription(), miPushMessage.getExtra());
  }

  @Override
  public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
    PushMessageHandleFactory.notificationMessageReceived(context, miPushMessage.getNotifyId(),
        miPushMessage.getTitle(), miPushMessage.getContent(), miPushMessage.getDescription(),
        miPushMessage.getExtra());
  }

  @Override
  public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
    PushMessageHandleFactory.notificationMessageClicked(context, miPushMessage.getNotifyId(),
        miPushMessage.getTitle(), miPushMessage.getContent(), miPushMessage.getDescription(),
        miPushMessage.getExtra());
  }

  @Override
  public void onCommandResult(Context context, MiPushCommandMessage message) {
    super.onCommandResult(context, message);
    String command = message.getCommand();
    List<String> arguments = message.getCommandArguments();
    String cmdArg1 = ((arguments != null && arguments.size() > 0) ? arguments.get(0) : null);
    String cmdArg2 = ((arguments != null && arguments.size() > 1) ? arguments.get(1) : null);
    int commandType = -1;
    if (MiPushClient.COMMAND_SET_ALIAS.equals(command)) {
      commandType = PushCommand.TYPE_BIND_ALIAS;
      if (message.getResultCode() == ErrorCode.SUCCESS) {
        mAlias = cmdArg1;
      }
    } else if (MiPushClient.COMMAND_UNSET_ALIAS.equals(command)) {
      commandType = PushCommand.TYPE_UNBIND_ALIAS;
      if (message.getResultCode() == ErrorCode.SUCCESS) {
        mAlias = cmdArg1;
      }
    } else if (MiPushClient.COMMAND_SET_ACCOUNT.equals(command)) {
      commandType = PushCommand.TYPE_BIND_ALIAS;
    } else if (MiPushClient.COMMAND_UNSET_ACCOUNT.equals(command)) {
      commandType = PushCommand.TYPE_UNBIND_ALIAS;
    }
    PushMessageHandleFactory.commandResult(context, commandType,
        message.getResultCode() == ErrorCode.SUCCESS ? PushCommand.RESULT_OK
            : PushCommand.RESULT_ERROR, cmdArg1);
  }
}
