package com.yx95.push.hwpush;

import android.app.Application;
import android.content.Context;

import com.yx95.push.PushCache;
import com.yx95.push.core.IPushClient;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushCommand;
import com.yx95.push.hwpush.agent.HMSAgent;
import com.yx95.push.hwpush.agent.push.handler.DeleteTokenHandler;
import com.yx95.push.hwpush.agent.push.handler.GetTokenHandler;
import com.yx95.push.util.PushLog;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.hwpush
 * @Description:
 * @TODO: TODO
 * @date 2019/6/4
 */
public class HWPushClient implements IPushClient {

    private Context mContext;

    @Override
    public void init(Context context) {
        mContext = context;
        HMSAgent.init((Application) context);
    }

    @Override
    public void bindAlias(String alias) {

    }

    @Override
    public void unBindAlias(String alias) {
    }

    @Override
    public void register() {
        HMSAgent.Push.getToken(new GetTokenHandler() {
            @Override
            public void onResult(int rst) {
                if (rst == HMSAgent.AgentResultCode.HMSAGENT_SUCCESS) {
                    PushLog.i("注册成功");
                } else {
                    PushMessageHandleFactory.commandResult(mContext, PushCommand.TYPE_REGISTER, PushCommand.RESULT_ERROR, "");
                }
            }
        });
    }

    @Override
    public void unRegister() {
        HMSAgent.Push.deleteToken(PushCache.getToken(mContext), new DeleteTokenHandler() {
            @Override
            public void onResult(int rst) {

            }
        });
    }
}
