package com.yx95.push.entity;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.entity
 * @Description: 推送消息实体
 * @TODO: TODO
 * @date 2018/6/25
 */
public class PushMessage implements Parcelable {
    //
    private int notifyId;
    private String title;
    private String content;
    private String msg;
    private String extraMsg;
    private Map<String, String> keyValue;

    public PushMessage(int notifyId, String title, String content, String msg, String extraMsg, Map<String, String> keyValue) {
        this.notifyId = notifyId;
        this.title = title;
        this.content = content;
        this.msg = msg;
        this.extraMsg = extraMsg;
        this.keyValue = keyValue;
    }

    protected PushMessage(Parcel in) {
        notifyId = in.readInt();
        title = in.readString();
        content = in.readString();
        msg = in.readString();
        extraMsg = in.readString();
        keyValue = in.readHashMap(HashMap.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(notifyId);
        dest.writeString(title);
        dest.writeString(content);
        dest.writeString(msg);
        dest.writeString(extraMsg);
        dest.writeMap(keyValue);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PushMessage> CREATOR = new Creator<PushMessage>() {
        @Override
        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        @Override
        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };

    public int getNotifyId() {
        return notifyId;
    }

    public void setNotifyId(int notifyId) {
        this.notifyId = notifyId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getExtraMsg() {
        return extraMsg;
    }

    public void setExtraMsg(String extraMsg) {
        this.extraMsg = extraMsg;
    }

    public Map<String, String> getKeyValue() {
        return keyValue;
    }

    public void setKeyValue(Map<String, String> keyValue) {
        this.keyValue = keyValue;
    }


    @Override
    public String toString() {
        return "PushMessage{" +
                "notifyId=" + notifyId +
                ", title='" + title + '\'' +
                ", content='" + content + '\'' +
                ", msg='" + msg + '\'' +
                ", extraMsg='" + extraMsg + '\'' +
                ", keyValue=" + keyValue +
                '}';
    }
}
