package com.yx95.push;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push
 * @Description:
 * @TODO: TODO
 * @date 2019/6/4
 */
public class PushCache {
  private static final String FILE_ONE_PUSH_CACHE = "push_cache";
  private static final String KEY_TOKEN = "token";
  private static final String KEY_PLATFORM = "platform";

  public static void putToken(Context context, String token) {
    getSharedPreferences(context).edit().putString(KEY_TOKEN, token).apply();
  }

  public static String getToken(Context context) {
    return getSharedPreferences(context).getString(KEY_TOKEN, null);
  }

  public static void delToken(Context context) {
    getSharedPreferences(context).edit().remove(KEY_TOKEN).apply();
  }

  public static void putPlatform(Context context, String platform) {
    getSharedPreferences(context).edit().putString(KEY_PLATFORM, platform).apply();
  }

  public static String getPlatform(Context context) {
    return getSharedPreferences(context).getString(KEY_PLATFORM, null);
  }

  public static void delPlatform(Context context) {
    getSharedPreferences(context).edit().remove(KEY_PLATFORM).apply();
  }

  private static SharedPreferences getSharedPreferences(Context context) {
    return context.getSharedPreferences(FILE_ONE_PUSH_CACHE, Context.MODE_PRIVATE);
  }
}
