/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.hwpush.agent.push;

import android.os.Handler;
import android.os.Looper;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.ResultCallback;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.push.HuaweiPush;
import com.huawei.hms.support.api.push.TokenResult;
import com.yx95.push.hwpush.agent.common.ApiClientMgr;
import com.yx95.push.hwpush.agent.common.BaseApiAgent;
import com.yx95.push.hwpush.agent.common.CallbackCodeRunnable;
import com.yx95.push.hwpush.agent.common.HMSAgentLog;
import com.yx95.push.hwpush.agent.common.StrUtils;
import com.yx95.push.hwpush.agent.push.handler.GetTokenHandler;

public class GetTokenApi
extends BaseApiAgent {
    private static final int MAX_RETRY_TIMES = 1;
    private GetTokenHandler handler;
    private int retryTimes = 1;

    @Override
    public void onConnect(int rst, HuaweiApiClient client) {
        if (client == null || !ApiClientMgr.INST.isConnect(client)) {
            HMSAgentLog.e("client not connted");
            this.onPushTokenResult(rst, null);
            return;
        }
        PendingResult tokenResult = HuaweiPush.HuaweiPushApi.getToken((ApiClient)client);
        tokenResult.setResultCallback((ResultCallback)new ResultCallback<TokenResult>(){

            public void onResult(TokenResult result) {
                if (result == null) {
                    HMSAgentLog.e("result is null");
                    GetTokenApi.this.onPushTokenResult(-1002, null);
                    return;
                }
                Status status = result.getStatus();
                if (status == null) {
                    HMSAgentLog.e("status is null");
                    GetTokenApi.this.onPushTokenResult(-1003, null);
                    return;
                }
                int rstCode = status.getStatusCode();
                HMSAgentLog.d("status=" + status);
                if ((rstCode == 907135006 || rstCode == 907135003) && GetTokenApi.this.retryTimes > 0) {
                    GetTokenApi.this.retryTimes--;
                    GetTokenApi.this.connect();
                } else {
                    GetTokenApi.this.onPushTokenResult(rstCode, result);
                }
            }
        });
    }

    void onPushTokenResult(int rstCode, TokenResult result) {
        HMSAgentLog.i("getToken:callback=" + StrUtils.objDesc(this.handler) + " retCode=" + rstCode);
        if (this.handler != null) {
            new Handler(Looper.getMainLooper()).post((Runnable)new CallbackCodeRunnable(this.handler, rstCode));
            this.handler = null;
        }
        this.retryTimes = 1;
    }

    public void getToken(GetTokenHandler handler) {
        HMSAgentLog.i("getToken:handler=" + StrUtils.objDesc(handler));
        this.handler = handler;
        this.retryTimes = 1;
        this.connect();
    }
}

