/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.hwpush.agent.common;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import com.huawei.hms.api.CheckUpdatelistener;
import com.huawei.hms.api.HuaweiApiClient;
import com.yx95.push.hwpush.agent.common.ActivityMgr;
import com.yx95.push.hwpush.agent.common.BaseApiAgent;
import com.yx95.push.hwpush.agent.common.CallbackCodeRunnable;
import com.yx95.push.hwpush.agent.common.HMSAgentLog;
import com.yx95.push.hwpush.agent.common.StrUtils;
import com.yx95.push.hwpush.agent.common.handler.CheckUpdateHandler;

public class CheckUpdateApi
extends BaseApiAgent
implements CheckUpdatelistener {
    private CheckUpdateHandler handler;
    private Activity activity;

    @Override
    public void onConnect(int rst, HuaweiApiClient client) {
        HMSAgentLog.d("onConnect:" + rst);
        Activity activityCur = ActivityMgr.INST.getLastActivity();
        if (activityCur != null && client != null) {
            client.checkUpdate(activityCur, (CheckUpdatelistener)this);
        } else if (this.activity != null && client != null) {
            client.checkUpdate(this.activity, (CheckUpdatelistener)this);
        } else {
            HMSAgentLog.e("no activity to checkUpdate");
            this.onCheckUpdateResult(-1001);
            return;
        }
    }

    public void onResult(int resultCode) {
        this.onCheckUpdateResult(resultCode);
    }

    private void onCheckUpdateResult(int retCode) {
        HMSAgentLog.i("checkUpdate:callback=" + StrUtils.objDesc(this.handler) + " retCode=" + retCode);
        if (this.handler != null) {
            new Handler(Looper.getMainLooper()).post((Runnable)new CallbackCodeRunnable(this.handler, retCode));
            this.handler = null;
        }
        this.activity = null;
    }

    public void checkUpdate(Activity activity, CheckUpdateHandler handler) {
        HMSAgentLog.i("checkUpdate:handler=" + StrUtils.objDesc(handler));
        this.handler = handler;
        this.activity = activity;
        this.connect();
    }
}

