/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.hwpush.agent.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.push.HuaweiPush;
import com.yx95.push.hwpush.agent.common.ActivityMgr;
import com.yx95.push.hwpush.agent.common.EmptyConnectCallback;
import com.yx95.push.hwpush.agent.common.HMSAgentActivity;
import com.yx95.push.hwpush.agent.common.HMSAgentLog;
import com.yx95.push.hwpush.agent.common.IActivityDestroyedCallback;
import com.yx95.push.hwpush.agent.common.IActivityPauseCallback;
import com.yx95.push.hwpush.agent.common.IActivityResumeCallback;
import com.yx95.push.hwpush.agent.common.IClientConnectCallback;
import com.yx95.push.hwpush.agent.common.StrUtils;
import com.yx95.push.hwpush.agent.common.ThreadUtil;
import com.yx95.push.hwpush.agent.common.UIUtils;
import java.util.ArrayList;
import java.util.List;

public final class ApiClientMgr
implements HuaweiApiClient.ConnectionCallbacks,
HuaweiApiClient.OnConnectionFailedListener,
IActivityResumeCallback,
IActivityPauseCallback,
IActivityDestroyedCallback {
    public static final ApiClientMgr INST = new ApiClientMgr();
    private static final String PACKAGE_NAME_HIAPP = "com.huawei.appmarket";
    private static final Object CALLBACK_LOCK = new Object();
    private static final Object STATIC_CALLBACK_LOCK = new Object();
    private static final Object APICLIENT_LOCK = new Object();
    private static final int APICLIENT_CONNECT_TIMEOUT = 30000;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT = 3000;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT = 3000;
    private static final int APICLIENT_TIMEOUT_HANDLE_MSG = 3;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT_HANDLE_MSG = 4;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT_HANDLE_MSG = 5;
    private static final int MAX_RESOLVE_TIMES = 3;
    private Context context;
    private String curAppPackageName;
    private HuaweiApiClient apiClient;
    private boolean allowResolveConnectError = false;
    private boolean isResolving;
    private BridgeActivity resolveActivity;
    private boolean hasOverActivity = false;
    private int curLeftResolveTimes = 3;
    private List<IClientConnectCallback> connCallbacks = new ArrayList<IClientConnectCallback>();
    private List<IClientConnectCallback> staticCallbacks = new ArrayList<IClientConnectCallback>();
    private Handler timeoutHandler = new Handler(new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            boolean hasConnCallbacks;
            Object object = CALLBACK_LOCK;
            synchronized (object) {
                hasConnCallbacks = !ApiClientMgr.this.connCallbacks.isEmpty();
            }
            if (msg != null && msg.what == 3 && hasConnCallbacks) {
                HMSAgentLog.d("connect time out");
                ApiClientMgr.this.resetApiClient();
                ApiClientMgr.this.onConnectEnd(-1007);
                return true;
            }
            if (msg != null && msg.what == 4 && hasConnCallbacks) {
                HMSAgentLog.d("start activity time out");
                ApiClientMgr.this.onConnectEnd(-1007);
                return true;
            }
            if (msg != null && msg.what == 5 && hasConnCallbacks) {
                HMSAgentLog.d("Discarded update dispose:hasOverActivity=" + ApiClientMgr.this.hasOverActivity + " resolveActivity=" + StrUtils.objDesc(ApiClientMgr.this.resolveActivity));
                if (ApiClientMgr.this.hasOverActivity && ApiClientMgr.this.resolveActivity != null && !ApiClientMgr.this.resolveActivity.isFinishing()) {
                    ApiClientMgr.this.onResolveErrorRst(13);
                }
                return true;
            }
            return false;
        }
    });

    private ApiClientMgr() {
    }

    public void init(Application app) {
        HMSAgentLog.d("init");
        this.context = app.getApplicationContext();
        this.curAppPackageName = app.getPackageName();
        ActivityMgr.INST.unRegisterActivitResumeEvent(this);
        ActivityMgr.INST.registerActivitResumeEvent(this);
        ActivityMgr.INST.unRegisterActivitPauseEvent(this);
        ActivityMgr.INST.registerActivitPauseEvent(this);
        ActivityMgr.INST.unRegisterActivitDestroyedEvent(this);
        ActivityMgr.INST.registerActivitDestroyedEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        HMSAgentLog.d("release");
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        HuaweiApiClient client = this.getApiClient();
        if (client != null) {
            client.disconnect();
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            this.apiClient = null;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.clear();
        }
        object = CALLBACK_LOCK;
        synchronized (object) {
            this.connCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HuaweiApiClient getApiClient() {
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            return this.apiClient != null ? this.apiClient : this.resetApiClient();
        }
    }

    public boolean isConnect(HuaweiApiClient client) {
        return client != null && client.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientConnect(IClientConnectCallback staticCallback) {
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.add(staticCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConnectCallback(IClientConnectCallback staticCallback) {
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.remove(staticCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HuaweiApiClient resetApiClient() {
        if (this.context == null) {
            HMSAgentLog.e("HMSAgent not init");
            return null;
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            if (this.apiClient != null) {
                ApiClientMgr.disConnectClientDelay(this.apiClient, 60000);
            }
            HMSAgentLog.d("reset client");
            this.apiClient = new HuaweiApiClient.Builder(this.context).addApi(HuaweiPush.PUSH_API).addConnectionCallbacks((HuaweiApiClient.ConnectionCallbacks)INST).addOnConnectionFailedListener((HuaweiApiClient.OnConnectionFailedListener)INST).build();
            return this.apiClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IClientConnectCallback callback, boolean allowResolve) {
        if (this.context == null) {
            this.aSysnCallback(-1000, callback);
            return;
        }
        HuaweiApiClient client = this.getApiClient();
        if (client != null && client.isConnected()) {
            HMSAgentLog.d("client is valid");
            this.aSysnCallback(0, callback);
            return;
        }
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            HMSAgentLog.d("client is invalid\uff1asize=" + this.connCallbacks.size());
            boolean bl = this.allowResolveConnectError = this.allowResolveConnectError || allowResolve;
            if (this.connCallbacks.isEmpty()) {
                this.connCallbacks.add(callback);
                this.curLeftResolveTimes = 3;
                this.startConnect();
            } else {
                this.connCallbacks.add(callback);
            }
        }
    }

    private void startConnect() {
        --this.curLeftResolveTimes;
        HMSAgentLog.d("start thread to connect");
        ThreadUtil.INST.excute(new Runnable(){

            @Override
            public void run() {
                HuaweiApiClient client = ApiClientMgr.this.getApiClient();
                if (client != null) {
                    HMSAgentLog.d("connect");
                    Activity curActivity = ActivityMgr.INST.getLastActivity();
                    ApiClientMgr.this.timeoutHandler.sendEmptyMessageDelayed(3, 30000L);
                    client.connect(curActivity);
                } else {
                    HMSAgentLog.d("client is generate error");
                    ApiClientMgr.this.onConnectEnd(-1002);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectEnd(int rstCode) {
        HMSAgentLog.d("connect end:" + rstCode);
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback callback : this.connCallbacks) {
                this.aSysnCallback(rstCode, callback);
            }
            this.connCallbacks.clear();
            this.allowResolveConnectError = false;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback callback : this.staticCallbacks) {
                this.aSysnCallback(rstCode, callback);
            }
            this.staticCallbacks.clear();
        }
    }

    private void aSysnCallback(final int rstCode, final IClientConnectCallback callback) {
        ThreadUtil.INST.excute(new Runnable(){

            @Override
            public void run() {
                HuaweiApiClient client = ApiClientMgr.this.getApiClient();
                HMSAgentLog.d("callback connect: rst=" + rstCode + " apiClient=" + client);
                callback.onConnect(rstCode, client);
            }
        });
    }

    @Override
    public void onActivityResume(Activity activity) {
        HuaweiApiClient client = this.getApiClient();
        if (client != null) {
            HMSAgentLog.d("tell hmssdk: onResume");
            client.onResume(activity);
        }
        HMSAgentLog.d("is resolving:" + this.isResolving);
        if (this.isResolving && !PACKAGE_NAME_HIAPP.equals(this.curAppPackageName)) {
            if (activity instanceof BridgeActivity) {
                this.resolveActivity = (BridgeActivity)activity;
                this.hasOverActivity = false;
                HMSAgentLog.d("received bridgeActivity:" + StrUtils.objDesc(this.resolveActivity));
            } else if (this.resolveActivity != null && !this.resolveActivity.isFinishing()) {
                this.hasOverActivity = true;
                HMSAgentLog.d("received other Activity:" + StrUtils.objDesc(this.resolveActivity));
            }
            this.timeoutHandler.removeMessages(5);
            this.timeoutHandler.sendEmptyMessageDelayed(5, 3000L);
        }
    }

    @Override
    public void onActivityPause(Activity activity) {
        HuaweiApiClient client = this.getApiClient();
        if (client != null) {
            client.onPause(activity);
        }
    }

    @Override
    public void onActivityDestroyed(Activity activityDestroyed, Activity activityNxt) {
        if (activityNxt == null) {
            this.resetApiClient();
        }
    }

    void onResolveErrorRst(int result) {
        HuaweiApiClient client;
        HMSAgentLog.d("result=" + result);
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        if (result == 0 && (client = this.getApiClient()) != null && !client.isConnecting() && !client.isConnected() && this.curLeftResolveTimes > 0) {
            this.startConnect();
            return;
        }
        this.onConnectEnd(result);
    }

    void onActivityLunched() {
        HMSAgentLog.d("resolve onActivityLunched");
        this.timeoutHandler.removeMessages(4);
        this.isResolving = true;
    }

    public void onConnected() {
        HMSAgentLog.d("connect success");
        this.timeoutHandler.removeMessages(3);
        this.onConnectEnd(0);
    }

    public void onConnectionSuspended(int cause) {
        HMSAgentLog.d("connect suspended");
        this.connect(new EmptyConnectCallback("onConnectionSuspended try end:"), true);
    }

    public void onConnectionFailed(ConnectionResult result) {
        this.timeoutHandler.removeMessages(3);
        if (result == null) {
            HMSAgentLog.e("result is null");
            this.onConnectEnd(-1002);
            return;
        }
        int errCode = result.getErrorCode();
        HMSAgentLog.d("errCode=" + errCode + " allowResolve=" + this.allowResolveConnectError);
        if (HuaweiApiAvailability.getInstance().isUserResolvableError(errCode) && this.allowResolveConnectError) {
            Activity activity = ActivityMgr.INST.getLastActivity();
            if (activity != null) {
                try {
                    this.timeoutHandler.sendEmptyMessageDelayed(4, 3000L);
                    Intent intent = new Intent((Context)activity, HMSAgentActivity.class);
                    intent.putExtra("HMSConnectionErrorCode", errCode);
                    intent.putExtra("should_be_fullscreen", UIUtils.isActivityFullscreen(activity));
                    activity.startActivity(intent);
                    return;
                }
                catch (Exception e) {
                    HMSAgentLog.e("start HMSAgentActivity exception:" + e.getMessage());
                    this.timeoutHandler.removeMessages(4);
                    this.onConnectEnd(-1004);
                    return;
                }
            }
            HMSAgentLog.d("no activity");
            this.onConnectEnd(-1001);
            return;
        }
        this.onConnectEnd(errCode);
    }

    private static void disConnectClientDelay(final HuaweiApiClient clientTmp, int delay) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                clientTmp.disconnect();
            }
        }, (long)delay);
    }
}

