package com.yx95.push.util;

import android.os.Build;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.util
 * @Description:
 * @date 2018/6/25
 */
public class PushUtils {
    public static final String ROM_MIUI = "XiaoMi";
    public static final String ROM_HUAWEI = "HuaWei";

    public static boolean isXiaoMi() {
        return Build.MANUFACTURER.equalsIgnoreCase(ROM_MIUI);
    }

    public static boolean isHuaWei() {
        return Build.MANUFACTURER.equalsIgnoreCase(ROM_HUAWEI);
    }

    public static Map<String, String> json2Map(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Iterator<String> keys = jsonObject.keys();
        HashMap<String, String> map = new HashMap<>();
        while (keys.hasNext()) {
            String next = keys.next();
            try {
                Object o = jsonObject.get(next);
                map.put(next, String.valueOf(o));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<String, String> getExtraMap(String extra) {
        Map<String, String> extraMap;
        try {
            extraMap = PushUtils.json2Map(new JSONObject(extra));
        } catch (JSONException e) {
            e.printStackTrace();
            extraMap = null;
        }
        return extraMap;
    }
}
