package com.yx95.push.jpush;

import android.content.Context;

import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushCommand;
import com.yx95.push.util.PushLog;
import com.yx95.push.util.PushUtils;

import java.util.Map;

import cn.jpush.android.api.CustomMessage;
import cn.jpush.android.api.JPushMessage;
import cn.jpush.android.api.NotificationMessage;
import cn.jpush.android.service.JPushMessageReceiver;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.jpush
 * @Description:
 * @TODO: TODO
 * @date 2019/5/25
 */
public class NJPushReceiver extends JPushMessageReceiver {

    @Override
    public void onMessage(Context context, CustomMessage customMessage) {
        PushLog.i("接受到推送下来的自定义消息(透传消息)");
        String message = customMessage.title;
        String desc = customMessage.message;
        Map<String, String> extraMap = PushUtils.getExtraMap(customMessage.extra);
        PushMessageHandleFactory.messageReceived(context, message, desc, extraMap);
    }

    @Override
    public void onNotifyMessageArrived(Context context, NotificationMessage notificationMessage) {
        PushLog.i("接受到推送下来的通知");
        String title = notificationMessage.notificationTitle;
        String content = notificationMessage.notificationContent;
        String extra = notificationMessage.notificationExtras;
        int notifyId = notificationMessage.notificationId;
        Map<String, String> extraMap = PushUtils.getExtraMap(extra);
        PushMessageHandleFactory.notificationMessageReceived(context, notifyId, title, content, extra, extraMap);
    }

    @Override
    public void onNotifyMessageOpened(Context context, NotificationMessage notificationMessage) {
        PushLog.i("点击推送消息");
        String title = notificationMessage.notificationTitle;
        String content = notificationMessage.notificationContent;
        String extra = notificationMessage.notificationExtras;
        int notifyId = notificationMessage.notificationId;
        Map<String, String> extraMap = PushUtils.getExtraMap(extra);
        PushMessageHandleFactory.notificationMessageClicked(context, notifyId, title, content, extra, extraMap);
    }

    @Override
    public void onAliasOperatorResult(Context context, JPushMessage jPushMessage) {
        super.onAliasOperatorResult(context, jPushMessage);
        PushMessageHandleFactory.commandResult(context, jPushMessage.getSequence(), jPushMessage.getErrorCode() == 0 ? PushCommand.RESULT_OK : jPushMessage.getErrorCode(), jPushMessage.getAlias());
    }

}
