package com.yx95.push.hwpush;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;

import com.huawei.hms.support.api.push.PushReceiver;
import com.yx95.push.PushCache;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushCommand;
import com.yx95.push.util.PushUtils;

import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.hwpush
 * @Description:
 * @TODO: TODO
 * @date 2019/6/4
 */
public class HWPushMessageReceiver extends PushReceiver {

    @Override
    public void onToken(Context context, String token, Bundle extras) {
        super.onToken(context, token, extras);
        PushCache.putToken(context, token);
        PushMessageHandleFactory.commandResult(context, PushCommand.TYPE_REGISTER, PushCommand.RESULT_OK, token);
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public boolean onPushMsg(Context context, byte[] msgBytes, Bundle extras) {
        String pushMsg = new String(msgBytes, StandardCharsets.UTF_8);
        Map<String, String> extraMap=PushUtils.getExtraMap(pushMsg);
        if (extraMap != null) {
            PushMessageHandleFactory.messageReceived(context, pushMsg, pushMsg, extraMap);
        }
        return false;
    }
}
