package com.yx95.push.entity;

import android.os.Parcel;
import android.os.Parcelable;

import com.yx95.push.core.PushCode;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.entity
 * @Description:
 * @TODO: TODO
 * @date 2019/6/4
 */
public class PushCommand implements Parcelable, PushCode {

    private int type;
    private int resultCode;
    private String msg;

    public PushCommand(int type, int resultCode, String msg) {
        this.type = type;
        this.resultCode = resultCode;
        this.msg = msg;
    }

    protected PushCommand(Parcel in) {
        type = in.readInt();
        resultCode = in.readInt();
        msg = in.readString();
    }

    public static final Creator<PushCommand> CREATOR = new Creator<PushCommand>() {
        @Override
        public PushCommand createFromParcel(Parcel in) {
            return new PushCommand(in);
        }

        @Override
        public PushCommand[] newArray(int size) {
            return new PushCommand[size];
        }
    };

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getResultCode() {
        return resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(type);
        parcel.writeInt(resultCode);
        parcel.writeString(msg);
    }
}
