package com.yx95.push.core;

import android.content.Context;

import com.heytap.msp.push.HeytapPushManager;
import com.vivo.push.PushClient;
import com.yx95.push.hwpush.HWPushClient;
import com.yx95.push.jpush.JPushClient;
import com.yx95.push.mipush.MIPushClient;
import com.yx95.push.oppo.OPPOClient;
import com.yx95.push.util.RomUtils;
import com.yx95.push.vivo.VivoClient;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.core
 * @Description:
 * @TODO: TODO
 * @date 2018/6/25
 */
public class PushCore implements PushCode {

  public static boolean DEBUG = true;

  private IPushClient mIPushClient;

  public static final String ACTION_NOTIFICATION_CLICKED = "com.yx95.push.NOTIFICATION_CLICKED";
  public static final String ACTION_MESSAGE_RECEIVED = "com.yx95.push.MESSAGE_RECEIVED";
  public static final String ACTION_NOTIFICATION_MESSAGE_RECEIVED =
      "com.yx95.push.NOTIFICATION_MESSAGE_ARRIVED";
  public static final String ACTION_COMMAND_RESULT = "com.yx95.push.COMMAND_RESULT";

  private static class ClassHolder {
    static PushCore pushCore = new PushCore();
  }

  public static PushCore getInstance() {
    return ClassHolder.pushCore;
  }

  public void openDebug(boolean openDebug) {
    DEBUG = openDebug;
  }

  /**
   * 初始化
   */
  public void init(Context context) {
    if (RomUtils.isXiaomi()) {
      mIPushClient = new MIPushClient();
    } else if (RomUtils.isHuawei()) {
      mIPushClient = new HWPushClient();
    } else if (RomUtils.isOppo()) {
      if (HeytapPushManager.isSupportPush()) {
        mIPushClient = new OPPOClient();
      } else {
        mIPushClient = new JPushClient();
      }
    } else if (RomUtils.isVivo()) {
      if (PushClient.getInstance(context).isSupport()) {
        mIPushClient = new VivoClient();
      } else {
        mIPushClient = new JPushClient();
      }
    } else {
      mIPushClient = new JPushClient();
    }
    mIPushClient.init(context);
    mIPushClient.register();
  }

  /**
   * 初始化
   *
   * @param onlyUseJPush 是否仅使用极光推送
   */
  public void init(Context context, boolean onlyUseJPush) {
    if (onlyUseJPush) {
      mIPushClient = new JPushClient();
    } else {
      init(context);
    }
    mIPushClient.init(context);
    mIPushClient.register();
  }

  /**
   * 绑定别名
   */
  public void bindAlias(String alias) {
    mIPushClient.bindAlias(alias);
  }

  /**
   * 解绑别名
   */
  public void unBindAlias(String alias) {
    mIPushClient.unBindAlias(alias);
  }
}
