/*
 * Decompiled with CFR 0.152.
 */
package com.yx95.push.core;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import com.yx95.push.entity.PushMessage;
import java.util.Map;

public class PushMessageHandleFactory {
    private static final String PUSH_DATA = "pushData";
    private static final int NO_NOTIFY_ID = 0;

    public static void notificationMessageClicked(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.NOTIFICATION_CLICKED", new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    public static void notificationMessageReceived(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.NOTIFICATION_MESSAGE_ARRIVED", new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    public static void messageReceived(Context context, String msg, String desc, Map<String, String> keyValue) {
        PushMessageHandleFactory.handleMessage(context, "com.yx95.push.MESSAGE_RECEIVED", new PushMessage(0, null, null, msg, desc, keyValue));
    }

    private static void handleMessage(Context context, String action, PushMessage pushMessage) {
        Intent intent = new Intent(action);
        intent.putExtra(PUSH_DATA, (Parcelable)pushMessage);
        intent.addCategory(context.getPackageName());
        context.sendBroadcast(intent);
    }

    public static Parcelable parseParcelable(Intent intent) {
        return intent.getParcelableExtra(PUSH_DATA);
    }
}

