package com.yx95.push.mipush;

import android.content.Context;

import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import com.yx95.push.core.PushMessageHandleFactory;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.bxkj.push.XMPush
 * @Description: 小米PushReceiver
 * @TODO: TODO
 * @date 2018/5/25
 */

public class MiPushMessageReceiver extends PushMessageReceiver {

    @Override
    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        PushMessageHandleFactory.messageReceived(context, miPushMessage.getContent(), miPushMessage.getDescription(),miPushMessage.getExtra());
    }

    @Override
    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
        PushMessageHandleFactory.notificationMessageReceived(context, miPushMessage.getNotifyId(), miPushMessage.getTitle(), miPushMessage.getContent(), miPushMessage.getDescription(), miPushMessage.getExtra());
    }

    @Override
    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
        PushMessageHandleFactory.notificationMessageClicked(context, miPushMessage.getNotifyId(), miPushMessage.getTitle(), miPushMessage.getContent(), miPushMessage.getDescription(), miPushMessage.getExtra());
    }
}
