package com.yx95.push.mipush;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.xiaomi.mipush.sdk.MiPushClient;
import com.yx95.push.PushLog;
import com.yx95.push.core.IPushClient;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.mipush
 * @Description:
 * @TODO: TODO
 * @date 2018/6/25
 */
public class MIPushClient implements IPushClient {

    public static final String MI_PUSH_APP_ID = "MI_PUSH_APP_ID";
    public static final String MI_PUSH_APP_KEY = "MI_PUSH_APP_KEY";

    private Context mContext;
    private String mAppId;
    private String mAppKey;

    @Override
    public void init(Context context) {
        mContext = context.getApplicationContext();
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA).metaData;
            mAppId = metaData.getString(MI_PUSH_APP_ID).trim();
            mAppKey = metaData.getString(MI_PUSH_APP_KEY).trim();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            PushLog.e("can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY on AndroidManifest.xml");
        }
    }

    @Override
    public void bindAlias(String alias) {
        MiPushClient.setAlias(mContext, alias, null);
    }

    @Override
    public void register() {
        MiPushClient.registerPush(mContext, mAppId, mAppKey);
    }

    @Override
    public void unRegister() {
        MiPushClient.unregisterPush(mContext);
    }
}
