package com.yx95.push.jpush;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;


import com.yx95.push.PushLog;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.util.PushUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

import cn.jpush.android.api.JPushInterface;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.bxkj.jdzj.jpush
 * @Description: 极光推送广播接收
 * @TODO: TODO
 * @date 2018/1/22
 */

public class JPushReceiver extends BroadcastReceiver {

    private static final String TAG = JPushReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (JPushInterface.ACTION_REGISTRATION_ID.equals(intent.getAction())) {

        } else if (JPushInterface.ACTION_MESSAGE_RECEIVED.equals(intent.getAction())) {
            PushLog.i("接受到推送下来的自定义消息(透传消息)");
            String message = bundle.getString(JPushInterface.EXTRA_TITLE);
            String desc = bundle.getString(JPushInterface.EXTRA_TITLE);
            PushMessageHandleFactory.messageReceived(context, message, desc, null);
        } else if (JPushInterface.ACTION_NOTIFICATION_RECEIVED.equals(intent.getAction())) {
            PushLog.i("接受到推送下来的通知");
            String title = bundle.getString(JPushInterface.EXTRA_NOTIFICATION_TITLE);
            String content = bundle.getString(JPushInterface.EXTRA_ALERT);
            String extra = bundle.getString(JPushInterface.EXTRA_EXTRA);
            int notifyId = bundle.getInt(JPushInterface.EXTRA_NOTIFICATION_ID);
            Map<String, String> extraMap;
            try {
                extraMap = PushUtils.json2Map(new JSONObject(extra));
            } catch (JSONException e) {
                e.printStackTrace();
                extraMap = null;
            }
            PushMessageHandleFactory.notificationMessageReceived(context, notifyId, title, content, extra, extraMap);
        } else if (JPushInterface.ACTION_NOTIFICATION_OPENED.equals(intent.getAction())) {
            Log.d(TAG, "用户点击打开了通知");
            String title = bundle.getString(JPushInterface.EXTRA_NOTIFICATION_TITLE);
            String content = bundle.getString(JPushInterface.EXTRA_ALERT);
            String extra = bundle.getString(JPushInterface.EXTRA_EXTRA);
            int notifyId = bundle.getInt(JPushInterface.EXTRA_NOTIFICATION_ID);
            Map extraMap;
            try {
                extraMap = PushUtils.json2Map(new JSONObject(extra));
            } catch (JSONException e) {
                e.printStackTrace();
                extraMap = null;
            }
            PushMessageHandleFactory.notificationMessageClicked(context, notifyId, title, content, extra, extraMap);
        } else {
            Log.d(TAG, "Unhandled intent - " + intent.getAction());
        }
    }

}
