package com.yx95.push.core;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;

import com.yx95.push.entity.PushMessage;

import java.util.Map;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.core
 * @Description: 推送消息处理
 * @TODO: TODO
 * @date 2018/6/25
 */
public class PushMessageHandleFactory {

    private static final String PUSH_DATA = "pushData";
    private static final int NO_NOTIFY_ID = 0;

    /**
     * 处理通知栏消息点击
     *
     * @param context
     * @param notifyId
     * @param title
     * @param content
     * @param keyValue
     */
    public static void notificationMessageClicked(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        handleMessage(context, PushCore.ACTION_NOTIFICATION_CLICKED, new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    /**
     * 处理消息送达
     *
     * @param context
     * @param notifyId
     * @param title
     * @param content
     * @param keyValue
     */
    public static void notificationMessageReceived(Context context, int notifyId, String title, String content, String desc, Map<String, String> keyValue) {
        handleMessage(context, PushCore.ACTION_NOTIFICATION_MESSAGE_RECEIVED, new PushMessage(notifyId, title, content, null, desc, keyValue));
    }

    /**
     * 处理透传消息
     *
     * @param context
     * @param content
     * @param desc
     * @param keyValue
     */
    public static void messageReceived(Context context, String msg
            , String desc, Map<String, String> keyValue) {
        handleMessage(context, PushCore.ACTION_MESSAGE_RECEIVED, new PushMessage(NO_NOTIFY_ID, null, null, msg, desc, keyValue));
    }

    private static void handleMessage(Context context, String action, PushMessage pushMessage) {
        Intent intent = new Intent(action);
        intent.putExtra(PUSH_DATA, pushMessage);
        intent.addCategory(context.getPackageName());
        context.sendBroadcast(intent);
    }

    public static Parcelable parseParcelable(Intent intent) {
        return intent.getParcelableExtra(PUSH_DATA);
    }
}
