package com.yx95.push.core;

import android.content.Context;

import com.yx95.push.jpush.JPushClient;
import com.yx95.push.mipush.MIPushClient;
import com.yx95.push.util.PushUtils;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push.core
 * @Description:
 * @TODO: TODO
 * @date 2018/6/25
 */
public class PushCore implements PushCode {

    public static final String ACTION_NOTIFICATION_CLICKED = "com.yx95.push.NOTIFICATION_CLICKED";
    public static final String ACTION_MESSAGE_RECEIVED = "com.yx95.push.MESSAGE_RECEIVED";
    public static final String ACTION_NOTIFICATION_MESSAGE_RECEIVED = "com.yx95.push.NOTIFICATION_MESSAGE_ARRIVED";

    private static class ClassHolder {
        public static PushCore pushCore = new PushCore();
    }

    public static PushCore getInstance() {
        return ClassHolder.pushCore;
    }

    public void init(Context context) {
        IPushClient iPushClient;
        if (PushUtils.isXiaoMi()) {
            iPushClient = new MIPushClient();
        } else {
            iPushClient = new JPushClient();
        }
        iPushClient.init(context);
        iPushClient.register();
    }
}
