package com.yx95.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;

import com.yx95.push.core.IPushReceiver;
import com.yx95.push.core.PushCore;
import com.yx95.push.core.PushMessageHandleFactory;
import com.yx95.push.entity.PushMessage;

/**
 * @author 45457
 * @version V1.0
 * @Project: jdzj
 * @Package com.yx95.push
 * @Description:
 * @TODO: TODO
 * @date 2018/6/25
 */
public abstract class PushReceiver extends BroadcastReceiver implements IPushReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Parcelable parcelable = PushMessageHandleFactory.parseParcelable(intent);
        switch (action) {
            case PushCore.ACTION_MESSAGE_RECEIVED:
                onMessageReceived(context, (PushMessage) parcelable);
                break;
            case PushCore.ACTION_NOTIFICATION_MESSAGE_RECEIVED:
                onNotificationMassageReceived(context, (PushMessage) parcelable);
                break;
            case PushCore.ACTION_NOTIFICATION_CLICKED:
                onNotificationMessageClicked(context, (PushMessage) parcelable);
                break;
            default:
                break;
        }
    }
}
